*COMDECK SIZES
***************************************************************************
*   THIS FILE CONTAINS ALL THE ARRAY SIZES FOR USE IN MOPAC.              *
*                                                                         *
*     THERE ARE ONLY  PARAMETERS THAT THE PROGRAMMER NEED SET:            *
*     MAXHEV = MAXIMUM NUMBER OF HEAVY ATOMS (HEAVY: NON-HYDROGEN ATOMS)  *
*     MAXLIT = MAXIMUM NUMBER OF HYDROGEN ATOMS.                          *
*     MAXTIM = DEFAULT TIME FOR A JOB. (SECONDS)                          *
*     MAXDMP = DEFAULT TIME FOR AUTOMATIC RESTART FILE GENERATION (SECS)  *
*                                                                         *
      PARAMETER (MAXHEV=60,   MAXLIT=90)
      PARAMETER (MAXTIM=90000, MAXDMP=90000)
*                                                                         *
***************************************************************************
*                                                                         *
*   THE FOLLOWING CODE DOES NOT NEED TO BE ALTERED BY THE PROGRAMMER      *
*                                                                         *
***************************************************************************
*                                                                         *
*    ALL OTHER PARAMETERS ARE DERIVED FUNCTIONS OF THESE TWO PARAMETERS   *
*                                                                         *
*      NAME                   DEFINITION                                  *
*     NUMATM         MAXIMUM NUMBER OF ATOMS ALLOWED.                     *
*     MAXORB         MAXIMUM NUMBER OF ORBITALS ALLOWED.                  *
*     MAXPAR         MAXIMUM NUMBER OF PARAMETERS FOR OPTIMISATION.       *
*     N2ELEC         MAXIMUM NUMBER OF TWO ELECTRON INTEGRALS ALLOWED.    *
*     MPACK          AREA OF LOWER HALF TRIANGLE OF DENSITY MATRIX.       *
*     MORB2          SQUARE OF THE MAXIMUM NUMBER OF ORBITALS ALLOWED.    *
*     MAXHES         AREA OF HESSIAN MATRIX                               *
***************************************************************************
      PARAMETER (VERSON=5.00D0)
      PARAMETER (NUMATM=MAXHEV+MAXLIT)
      PARAMETER (MAXORB=4*MAXHEV+MAXLIT)
      PARAMETER (MAXPAR=3*NUMATM)
      PARAMETER (MAXBIG=MAXORB*MAXORB*2)
      PARAMETER (N2ELEC=2*(50*MAXHEV*(MAXHEV-1)+10*MAXHEV*MAXLIT
     +                     +(MAXLIT*(MAXLIT-1))/2))
      PARAMETER (MAXHES=(MAXPAR*(MAXPAR+1))/2,MORB2=MAXORB**2)
      PARAMETER (MPACK=(MAXORB*(MAXORB+1))/2)
***************************************************************************
*   FOR SHORT VERSION USE LINE WITH NMECI=1, FOR LONG VERSION USE LINE    *
*   WITH NMECI=10                                                         *
***************************************************************************
      PARAMETER (NMECI=10,  NPULAY=MPACK)
C     PARAMETER (NMECI=1,   NPULAY=1)
***************************************************************************
*DECK MOPAC
