C----------------------------------------------------------------------C 
C File : enrlnl.f                                                      C 
C Created: 08/05/91 IS                                                 C 
C History: See below                                                   C 
C----------------------------------------------------------------------C 
C                                                                      
C   02-JUN-91  THE ORDER OF LOOPS OVER IONS AND NON-LOCAL POTENTIALS   
C              HAS BEEN CHANGED. IN THE PARALLEL VERSION THE LOOP      
C              OVER IONS MUST BE THE LAST ONE.   (IS)                  
C
C   15-JUL-91  NODE INDEX REMOVED FROM ALL LOOKUP TABLES; I.E. EACH NODE 
C              STORES ONLY ITS OWN LOOKUP TABLE.   (IS)                  
C----------------------------------------------------------------------
      SUBROUTINE ENRLNL(VOL,NGX,NGY,NGZ,VNL,NN,NPKPT,NPLWV,NRPLWV,
     &   NRGRPT,NIONSP,NRLPPI,NBANDS,NKPTS,NSPEC,CRWFPI,CRSPWF,
     &   CPHGRD,NRLNL,NIONST,MXRLNL,IRLNL,PRLSCA,VRLGRD,NADGRD,MXRLSH,
     &   CESAVE)
C======================================================================
C THIS SUBROUTINES CALCULATES THE CONTRIBUTION OT THE BAND ENERGY DUE
C TO THE NON-LOCAL PSEUDOPOTENTIAL USING THE REAL SPACE METHOD OF
C KING-SMITH AND PAYNE
C======================================================================
C                                            
      IMPLICIT REAL*8 (A,B,D-H,O-Z)          
      IMPLICIT COMPLEX*16 (C)                
C                                            
      DIMENSION VNL(NBANDS,NKPTS),NIONSP(NSPEC),NRLPPI(NIONST)
      DIMENSION CRWFPI(NPLWV),CRSPWF(NPLWV),CPHGRD(NRGRPT,NIONST)
      DIMENSION NRLNL(NSPEC),IRLNL(MXRLNL,NSPEC),PRLSCA(MXRLNL,NSPEC)
      DIMENSION VRLGRD(NRGRPT,MXRLSH,NIONST),NADGRD(NRGRPT,NIONST)
C========================================================================  
C WORK ARRAYS FOR COMMUNICATIONS IN REAL SPACE NON-LOCAL PSEUDOPOTENTIALS  
C======================================================================== 
      DIMENSION CESAVE(NIONST,20)
C======================================================================
C CRWFPI IS USED TO STORE THE WAVEFUNCTION COMPONENTS AROUND A
C PARTICULAR ATOM
C CRSPWF IS THE WAVEFUNCTION OF THE PRESENT BAND ON THE REAL SPACE GRID
C NN IS THE CURRENT BAND INDEX AND NPKPT THE PRESENT K POINT
C======================================================================
C SCALE IS THE SCALING FACTOR THAT ACCOUNTS FOR THE VOLUME ELEMENT
C IN THE REAL SPACE INTEGRAL AND THE NORMALISATION APPLIED TO THE
C SHPERICAL HARMONICS
C======================================================================
      DATA PI / 3.14159265359 /
C======================================================================
      SCALE=VOL/(4.D0*PI*(DFLOAT(NGX*NGY*NGZ))**2)
C======================================================================
C INITIALISE THE NON-LOCAL ENERGY FOR THIS BAND TO ZERO
C======================================================================
      VNL(NN,NPKPT)=0.D0
C=======================================================================
C START THE LOOP OVER SPECIES
C=======================================================================
      DO 123 NSP=1,NSPEC
      NPIONT=0
      DO 40 IS=1,NSP-1
      NPIONT=NPIONT+NIONSP(IS)
 40   CONTINUE
      NIND=1
C=======================================================================
C START LOOP OVER NON-LOCAL POTENTIALS FOR THIS ATOM
C=======================================================================
      DO 126 NNL=1,NRLNL(NSP)
C======================================================================
C INITIALISE THE WORK ARRAY CESAVE TO ZERO
C======================================================================
      DO 50 I=1,5
      DO 50 J=1,NIONST
      CESAVE(J,I)=(0.D0,0.D0)
 50   CONTINUE
C=======================================================================
C START THE LOOP OVER THE IONS
C=======================================================================
      DO 124 NI=1,NIONSP(NSP)    
C======================================================================= 
C SET THE ION COUNTER                                                    
C======================================================================= 
      NPION=NPIONT+NI                               
C======================================================================
C INITIALISE THE WORK VARIABLES TO ZERO
C======================================================================
      CVDSS =(0.D0,0.D0)
      CVDSPX=(0.D0,0.D0)
      CVDSPY=(0.D0,0.D0)
      CVDSPZ=(0.D0,0.D0)
      CVDSD1=(0.D0,0.D0)
      CVDSD2=(0.D0,0.D0)
      CVDSD3=(0.D0,0.D0)
      CVDSD4=(0.D0,0.D0)
      CVDSD5=(0.D0,0.D0)
C=======================================================================
C GATHER THE WAVEFUNCTION COEFFICIENTS FOR THIS ION WITH THE
C RELEVANT PHASE FACTORS
C=======================================================================
      DO 125 NRG=1,NRLPPI(NPION)
      CRWFPI(NRG)=CRSPWF(NADGRD(NRG,NPION))*CPHGRD(NRG,NPION)
 125  CONTINUE
C=======================================================================
C 'S' POTENTIAL
C=======================================================================
      IF(IRLNL(NNL,NSP).EQ.0) THEN
      DO 127 NRG=1,NRLPPI(NPION)
      CVDSS=CVDSS+VRLGRD(NRG,NIND,NPION)*CRWFPI(NRG)
 127  CONTINUE
      CESAVE(NI,1)=CVDSS
      GO TO 124
      ENDIF
C=======================================================================
C 'P' POTENTIAL
C=======================================================================
      IF(IRLNL(NNL,NSP).EQ.1) THEN
      DO 128 NRG=1,NRLPPI(NPION)
      CVDSPX=CVDSPX+VRLGRD(NRG,NIND,NPION)*CRWFPI(NRG)
      CVDSPY=CVDSPY+VRLGRD(NRG,NIND+1,NPION)*CRWFPI(NRG)
      CVDSPZ=CVDSPZ+VRLGRD(NRG,NIND+2,NPION)*CRWFPI(NRG)
 128  CONTINUE
      CESAVE(NI,1)=CVDSPX
      CESAVE(NI,2)=CVDSPY
      CESAVE(NI,3)=CVDSPZ
      GO TO 124
      ENDIF
C======================================================================
C 'D' POTENTIAL
C======================================================================
      IF(IRLNL(NNL,NSP).EQ.2) THEN
      DO 129 NRG=1,NRLPPI(NPION)
      CVDSD1=CVDSD1+VRLGRD(NRG,NIND,NPION)*CRWFPI(NRG)
      CVDSD2=CVDSD2+VRLGRD(NRG,NIND+1,NPION)*CRWFPI(NRG)
      CVDSD3=CVDSD3+VRLGRD(NRG,NIND+2,NPION)*CRWFPI(NRG)
      CVDSD4=CVDSD4+VRLGRD(NRG,NIND+3,NPION)*CRWFPI(NRG)
      CVDSD5=CVDSD5+VRLGRD(NRG,NIND+4,NPION)*CRWFPI(NRG)
 129  CONTINUE
      CESAVE(NI,1)=CVDSD1
      CESAVE(NI,2)=CVDSD2
      CESAVE(NI,3)=CVDSD3
      CESAVE(NI,4)=CVDSD4
      CESAVE(NI,5)=CVDSD5
      ENDIF
C======================================================================
C END ION LOOP
C======================================================================
 124  CONTINUE
C=======================================================================
C ADD THE 'S' CONTRIBUTION TO THE NON-LOCAL ENERGY
C=======================================================================
      IF(IRLNL(NNL,NSP).EQ.0) THEN
      DO 10 NION=1,NIONST
      VNL(NN,NPKPT)=VNL(NN,NPKPT)+
     &              DBLE(CESAVE(NION,1)*CONJG(CESAVE(NION,1)))*    
     &              SCALE/PRLSCA(NNL,NSP)
 10   CONTINUE
      NIND=NIND+1
      GOTO 126
      ENDIF
C=======================================================================
C ADD THE 'P' CONTRIBUTION TO THE NON-LOCAL ENERGY
C=======================================================================
      IF(IRLNL(NNL,NSP).EQ.1) THEN
      DO 20 NION=1,NIONST
      VNL(NN,NPKPT)=VNL(NN,NPKPT)+
     &              DBLE(CESAVE(NION,1)*CONJG(CESAVE(NION,1))+
     &                   CESAVE(NION,2)*CONJG(CESAVE(NION,2))+
     &                   CESAVE(NION,3)*CONJG(CESAVE(NION,3)))*
     &              SCALE/PRLSCA(NNL,NSP)
 20   CONTINUE
      NIND=NIND+3
      GOTO 126
      ENDIF
C=======================================================================
C ADD THE 'D' CONTRIBUTION TO THE NON-LOCAL ENERGY
C=======================================================================
      IF(IRLNL(NNL,NSP).EQ.2) THEN
      DO 30 NION=1,NIONST
      VNL(NN,NPKPT)=VNL(NN,NPKPT)+
     &              DBLE(CESAVE(NION,1)*CONJG(CESAVE(NION,1))+
     &                   CESAVE(NION,2)*CONJG(CESAVE(NION,2))+
     &                   CESAVE(NION,3)*CONJG(CESAVE(NION,3))+
     &                   CESAVE(NION,4)*CONJG(CESAVE(NION,4))+
     &                   CESAVE(NION,5)*CONJG(CESAVE(NION,5)))*
     &              SCALE/PRLSCA(NNL,NSP)
 30   CONTINUE
      NIND=NIND+5
      ENDIF
C======================================================================
C END LOOP OVER NON-LOCAL POTENTIALS
C======================================================================
 126  CONTINUE
C======================================================================
C END SPECIES LOOP
C======================================================================
 123  CONTINUE
      RETURN
      END

