/*
      viewParty	    	Party,
      viewSubtree	OBJECT IDENTIFIER,
      viewStatus 	INTEGER,
      viewMask		OCTET STRING

 */

#define VIEWPARTY 	1
#define VIEWSUBTREE 	2
#define VIEWSTATUS 	3
#define VIEWMASK 	4

#define VIEWNONEXISTENT 	0
#define VIEWINCLUDED		1
#define VIEWEXCLUDED		2
#define VIEWINVALID		3


struct viewEntry {
    oid		viewParty[32];
    int		viewPartyLen;
    oid		viewSubtree[32];
    int		viewSubtreeLen;
    int		viewStatus;
    u_char	viewMask[32];
    int		viewMaskLen;

    u_long	viewBitMask;

    struct viewEntry *reserved;
    struct viewEntry *next;
};

u_char *var_view();
int write_view();

struct viewEntry *
view_getEntry(/* oid *viewParty, int viewPartyLen,
		 oid viewSubtree, int viewSubtreeLen */);
/*
 * Returns a pointer to the viewEntry with the
 * same viewParty and viewSubtree
 * Returns NULL if that entry does not exist.
 */

view_scanInit();
/*
 * Initialized the scan routines so that they will begin at the
 * beginning of the list of viewEntries.
 *
 */


struct viewEntry *
view_scanNext();
/*
 * Returns a pointer to the next viewEntry.
 * These entries are returned in no particular order,
 * but if N entries exist, N calls to view_scanNext() will
 * return all N entries once.
 * Returns NULL if all entries have been returned.
 * view_scanInit() starts the scan over.
 */

struct viewEntry *
view_createEntry(/* oid *viewParty, int viewPartyLen,
		 oid viewSubtree, int viewSubtreeLen */);
/*
 * Creates a viewEntry with the given index
 * and returns a pointer to it.
 * The status of this entry is created as invalid.
 */



