/*+ 
** $Header
**/

/*+
 *
 * FUNCTION:
 * 	To display the help page by reading the file HELPFILE
 *
 *  -Vikas Aggarwal, vikas@navya.com
 */

/*
 * 	$Log: help_page.c,v $
 * Revision 1.6  1994/11/29  20:40:34  vikas
 * Updated as netconsole for v4.0
 *
 * Revision 1.5  1994/05/16  01:59:12  vikas
 * Cleanup for new release.
 *
 *
 * Revision 1.2  1990/03/21  15:27:08  aggarwal
 * replaced clrtoeol() with wclrtoeol(hwin)
 *
 * Revision 1.1  90/03/09  13:05:58  aggarwal
 * Initial revision
 * 
 * 
 */

#include	"netconsole.h"
#include 	<sys/file.h>

#ifndef HELPFILE
#define HELPFILE	"helpfile"
#endif
#define WFULL(w)  	(w->_cury == (w->_maxy - 2)) ? 1:0

help_page()
{
    extern int errno;
    extern char *sys_errlist[];
    extern char *helpfile ;			/* In netconsole.h  */
    WINDOW *hwin;
    char buffer[MAXLINE], *strcat() ;
    int i = 1, fd ;

    hwin= newwin( 0, 0, 0, 0 );
    touchwin(hwin) ;

    help_title(hwin, i) ;			/* display fancy title	*/
    if ((fd = open(helpfile, O_RDONLY)) < 0)
    {
	wprintw(hwin,"NetConsole help (open) %s: %s\n", 
		helpfile, sys_errlist[errno]);
	wprintw(hwin, "\nHit any key to continue: ");
	wclrtobot(hwin);
	wrefresh(hwin);
	getchar();
	return(1);
    }

    for ( ; ; )			/* display screenfuls of the helpfile	*/
    {
	while (!(WFULL(hwin)) && fdgets(buffer, MAXLINE, fd) != 0)
	  wprintw(hwin, "%s", buffer);
	
	if (WFULL(hwin))			/* window filled	*/
	{
	    wprintw (hwin, "\n--More--");
	    wclrtoeol(hwin);
	    wrefresh(hwin);
	    if (getchar() == 'q')
	      break ;				/* from outer 'for'	*/
	}
	else					/* end of the file	*/
	{
	    wprintw(hwin, "\nHit any key to return: ");
	    wclrtoeol(hwin);
	    wclrtobot(hwin);			/* Remove old trash	*/
	    wrefresh(hwin) ;
	    getchar() ;
	    break ;				/* from outer for loop	*/
	}
	werase(hwin);
	help_title(hwin, ++i);
    }						/* end:  for		*/
    close(fd);
    return(0);					/* all OK	*/

}						/* end: help_page	*/


help_title(hwin, hpage)
     WINDOW *hwin;
     int hpage;
{
    wstandout (hwin);
    mvwprintw (hwin, 0, (int)(COLS/2 - 11), "NETCONSOLE HELP SCREEN (%d)\n\n",
	       hpage);
    wstandend (hwin);

    return(1) ;
}
/*+ 
** FUNCTION:
** 	Read in  a string from the open file desc. Keeps newline and
** appends a NULL at the end of the string
**/
fdgets(buf, bufsiz, fd)
     char *buf;
     int bufsiz, fd;
{
    register n, i = 0;

    if (bufsiz <= 0)
      return(-1);			/* invalid buffer size	*/

    while ((n = read(fd, &(buf[i]), 1)) > 0  &&  buf[i++] != '\n')
      if (i == (bufsiz - 1))
	break;

    buf[i] = '\0';	      		/* Append a null character	*/
    if (n <= 0)				/* No characters read		*/
      return(0);
    else
      return(n) ;			/* Num of characters read	*/

}					/* end: fdgets	*/
