/*
**	$Header: /home/vikas/netmgt/nocol/src/netconsole/RCS/fill_window.c,v 1.10 1994/11/29 20:40:34 vikas Exp $
*/

/*+ 
 * 	This function fills the window given with files from the
 * specified directory pointer. A pointer to the funtion that is to be
 * called to display one line from the data files is passed. This is
 * done to make this function usable for both the EVENT window as well
 * as the MESSAGES window.
 *
 * LOGIC
 *	1) Skip over any file that begins with a "." or named 'core'
 *	2) Reset to start of window (needed since we are using WFULL
 *	   to decide when to stop putting out lines.
 *	3) Get next file in directory
 *	   - if directory type then skip
 *     	   - open file
 *	4) If end of directory, close and return 1
 *	5) If not FULL, call display_function
 *	   else return(0)
 *	6) If end of file,
 *	    - close file
 *	    - open next file
 *	    - if end of dir, clrtobot, return(1)
 *
 * 
 * RETURN VALUE
 *	1 if all files in directory are displayed.
 *	0 if all files have not yet been displayed.
 *
 * AUTHOR
 *	Vikas Aggarwal, vikas@navya.com
 */


/*
 *
 *	$Log: fill_window.c,v $
 * Revision 1.10  1994/11/29  20:40:34  vikas
 * Updated as netconsole for v4.0
 *
 * Revision 1.9  1994/06/12  18:09:35  vikas
 * Deleted the 'options' variable and set debug/quiet/emode to
 * be simple integers instead.
 *
 * Revision 1.8  1994/05/16  01:59:12  vikas
 * Cleanup for new release.
 *
 * Revision 1.7  1993/10/30  03:52:08  aggarwal
 * Now uses dirent(). Deleted include dir.h
 *
 * Revision 1.6  1993/10/05  04:17:41  aggarwal
 * Now skips over 'core' files.
 *
 * Revision 1.5  1992/06/18  21:03:22  aggarwal
 * Cleaned up for releasing.
 *
 * Revision 1.3  1990/05/23  17:21:21  aggarwal
 * Uncommented wmove() - see preamble (comments).
 *
 * Revision 1.2  90/05/13  22:27:02  aggarwal
 * Commented out the line for resetting the window position to (0,0) 
 * since that should depend on the window being operated upon - the msg
 * win can scroll so I don't want to reset the cursor position for the 
 * msg window. Have moved the line to the event_dpy.c module instead.
 * Added ' fstat' so that a directory is skipped and not treated as a 
 * data file. 
 * 
 * Revision 1.1  90/03/09  13:05:47  aggarwal
 * Initial revision
 * 
 */

#include	"netconsole.h"

#define WFULL(w)  	(w->_cury == (w->_maxy - 1)) ? 1:0

fill_window(win, dirp, dir, pcurfd, dpy_func)
     WINDOW *win;			/* Window to be filled		*/
     char *dir ;			/* Name of the directory	*/
     DIR *dirp;				/* opened directory pointer	*/
     int *pcurfd;			/* Present opened file desc	*/
     int (*dpy_func)();			/* Display function		*/
{
    struct dirent *direntry ;
    char file[MAXLINE];
    int opennew = 0;				/* boolean to open file	*/


    wmove(win, 0, 0);				/* reset to start pos	*/
    
    if (*pcurfd == 0)				/* No file open...	*/
      opennew = 1 ;

open_file:
    while (opennew)			/* open new file until successful */
    {
	struct stat buf ;		/* for fstat */

	if (*pcurfd > 0)		/* close any currently open file */
	  close(*pcurfd);

	if ((direntry = readdir(dirp)) == NULL)
	{					/* All files are done	*/
	    wclrtobot(win);			/* Clear win to bottom	*/
	    *pcurfd = 0;			/* reset to zero	*/
	    return (1);				/* All files displayed	*/
	}

	/* name begins with a dot or 'core' or is not a file */
	if (*(direntry->d_name) == '.' || strcmp(direntry->d_name, "core") ==0)
	  goto open_file ;		      	/* ...so skip it	*/

	sprintf (file, "%s/%s\0", (char *)dir, (char *)direntry->d_name);
	
	if ((*pcurfd = open(file, O_RDONLY)) == -1)	/* error */
	{
	    wprintw (aw.wmsg,
		     "\nERROR fill_win(open): '%s'- %s",
		     direntry->d_name, sys_errlist[errno]);
	    continue ;
	}

	/*
	 * Here if safely opened data file
	 */
	fstat (*pcurfd, &buf);		/* Get info about fd	*/
	if ((buf.st_mode & S_IFMT) == S_IFDIR)	/* It is a dir	*/
	{					/* ..so open another	*/
	    close(*pcurfd);
	    goto open_file ;
	}

	opennew = 0;			/* Don't open another	*/
	if (debug)
	  wprintw (aw.wmsg, 
		   "\n(DEBUG) fill_win: Opened file %s... ", direntry->d_name);

    }		/* end:  while opennew	*/

    while (!(WFULL(win)))
      if (dpy_func(*pcurfd, win) == 0)		/* end of file		*/
      {
	  opennew = 1;				/* open another file	*/
	  goto open_file ;
      }
    return (0) ;				/* Window full		*/

}						/* end: fill_window	*/
