/* $Header: /home/vikas/netmgt/nocol/src/lib/RCS/bsdsignal.c,v 1.1 1994/05/09 01:30:19 vikas Exp $ */

#ifdef SVR4

/*
 * Emulate BSD signal routines for SVR4 machines. See page 298 of Stevens'
 * "Advanced Programming in Unix Environment" book.
 *
 *	-Vikas Aggarwal  vikas@jvnc.net
 */

#include <signal.h>

void bsdsignal(signo, func)
     int signo;
     void *func;
{
    struct sigaction	act, oact;

    act.sa_handler = func;
    sigemptyset(&act.sa_mask);act.sa_flags = 0;
    if (signo == SIGALRM)
    {
#ifdef SA_INTERRUPT
	act.sa_flags |= SA_INTERRUPT;	/* SunOS */
#endif
    }
    else
    {
#ifdef SA_RESTART
	act.sa_flags |= SA_RESTART;	/* SVR4, BSD */
#endif
    }

    act.sa_flags |= (SA_SIGINFO|SA_ONSTACK);

    if (sigaction(signo, &act, &oact) < 0) {
	perror ("bsdsignal (sigaction):");
/*	return(SIG_ERR);	/* return a value only if not void() */
    }
/*    return(oact.sa_handler);	/* return a value only if not void() */

}

#endif	/* SVR4 */
	
