/*
 * $Header: /home/vikas/netmgt/nocol/src/include/RCS/trapmon.h,v 1.10 1994/05/16 01:40:45 vikas Exp $
 */
#ifndef __trapmon_h
# define __trapmon_h

#include <sys/types.h>
#include <netinet/in.h>
#include <stdio.h>
#include <time.h>
#include <sys/time.h>
#include <errno.h>
#include <syslog.h>
#include <fcntl.h>
#include <string.h>
#include <sys/socket.h>
#include <netdb.h>

#include "nocol.h"				/* For O_NOCOL output */

#include "snmp.h"
#include "snmp_impl.h"
#include "asn1.h"
#include "snmp_api.h"
#include "snmp_client.h"


#ifndef HAVE_FD_MACROS
# ifdef BSD4_3					/* BSD4.3 already has these */
#  define HAVE_FD_MACROS
# endif
# ifdef FD_SET
#  define HAVE_FD_MACROS
# endif
#endif

/* Macros for use with snmp_select_info() and select() */
#ifndef HAVE_FD_MACROS
typedef long    fd_mask;
#define NFDBITS (sizeof(fd_mask) * NBBY)        /* bits per mask */
#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)      bzero((char *)(p), sizeof(*(p)))
#endif /*end of #ifdef HAVE_FD_MACROS */

/* These #define's handle 4.2 systems without additional syslog facilities. */
#ifndef LOG_CONS
#define LOG_CONS        0       /* Don't bother if not defined... */
#endif
#ifndef LOG_LOCAL0
#define LOG_LOCAL0      0
#endif


/*
** SNMP_TRAP_MAX is the largest valid SNMP_TRAP_* number
** SNMP_TRAP_MAX + 1 is the canonical unknown/invalid trap number
** This really belongs in "snmp.h" with the SNMP_TRAP_* define's there
#define SNMP_TRAP_MAX	0x6

/*
 * Describe all the possible traps here and their severity levels here.
 * Note that the location of the traps in the array depends on the int
 * value assigned to the various trap types in 'snmp.h'
 */

struct t_desc {
    char  *tname ;		/* Trap name */
    int   tseverity ;		/* Trap severity as described in nocol.h */
    char  *tseverity_str ;	/* Severity description strings */
    int   nocop ;		/* Operation status n_UP, n_DOWN, n_UNKNOWN */
    int   loglevel ;		/* For noclogd logging level */
} ;

struct t_desc trap_desc[] = {
  { "Cold_Start", E_WARNING, "Warning", n_UP, E_WARNING },	/* trap 0 */
  { "Warm_Start", E_WARNING, "Warning", n_UP, E_WARNING },	/* trap 1 */
  { "Link_Down",  E_ERROR,   "ERROR", n_DOWN, E_ERROR},		/* trap 2 */
  { "Link_Up",    E_ERROR,   "ERROR", n_UP, E_ERROR},		/* trap 3 */
  { "Auth_Failure", E_WARNING, "Warning", n_UP, E_WARNING},	/* trap 4 */
  { "EGP_Peer_Loss", E_CRITICAL, "CRITICAL", n_DOWN, E_CRITICAL}, /* trap 5 */
  { "Enterprise", E_WARNING, "Warning", n_UNKNOWN, E_WARNING},	/* trap 6 */
  { "Unknown_Type", E_WARNING, "Warning", n_UNKNOWN, E_WARNING}	/* trap 7 */
} ;



/*
** Possible options:
**  O_NOCOL:	output EVENT structures to file for use with nocol
**  O_LOG:	output to syslog()
**  O_PRINT:	output to stderr
** See the 'options' global variable below
*/
#define O_NOCOL		0x1
#define O_LOG		0x2
#define O_PRINT		0x4

/*
 * Timeout for each EVENT in seconds - currently set to 30 minutes.
 * Trap events older than this will be deleted from the data file.
 */
#define TIME_TO_LIVE	(30*60)		/* convert to seconds */

/* Timeout for select() in seconds - currently set to 5 minutes */
#define SELECT_TIMEOUT	(5*60)

#define MAX_PATH_LEN	256			/* Longest path expected */
#define VARUNITS	"Trap"			/* NOCOL event.var.units */
#define MAX_TRAPS	256			/* Max # of unresolved traps */

extern int	errno;
int		snmp_dump_packet = 0;
int		options;			/* Command line options */
time_t		die_at[MAX_TRAPS];		/* When this EVENT times out */
int		numtraps;			/* # of outstanding EVENTs */
int		debug;				/* verbose debugging msgs */

#endif	/* ! __trapmon_h */
