/*+ 
 * $Header: /home/vikas/netmgt/nocol/src/eventselect/RCS/proc_datafile.c,v 1.5 1994/06/12 16:37:47 vikas Exp $
 */

/* Copyright 1994 Vikas Aggarwal, vikas@navya.com */

/*+ 
 * FUNCTION:
 * 	This program processes each open file descriptor that is
 * passed to it. If the severity + sender string + sitename + time
 * match, then it prints/logs the line in the NOCOL format.
 *
 */

/*+
 * $Log: proc_datafile.c,v $
 * Revision 1.5  1994/06/12  16:37:47  vikas
 * Changed all references from 'myname' and 'debugflag' to
 * 'prognm' and 'debug' since these are the names used throughout.
 *
 * Revision 1.4  1994/05/16  01:25:56  vikas
 * *** empty log message ***
 *
 * Revision 1.3  1994/01/04  00:00:16  aggarwal
 * Needed to supply pointers for bcmp()
 *
 * Revision 1.2  1993/10/30  03:18:33  aggarwal
 * Now uses get_date() instead of the Sun specific  timelocal() call
 *
 * Revision 1.1  1993/10/02  05:23:56  aggarwal
 * Initial revision
 *
 *
 */

#include <stdio.h>
#ifdef ultrix
#include <time.h>
#else
#include <sys/time.h>
#endif

#include "nocol.h"

static struct tm curtm;			/* present time in tm structure	*/
char   *event_to_logstr();		/* format event in string format */  

extern  char	**senderlist, **sitenamelist ;	/* defined in main() */
extern  int	minseverity, logevents, debug ;
extern  time_t	fromtime, totime;

proc_datafile (fd)
     int fd;				/* file descriptor  */
{
    static EVENT null_event ;		/* all null for testing	*/
    EVENT v;				/* storage for the event  */
    int status, bufsize;		/* for exit status   */
    time_t locclock ;

    /* get present time and keep it constant while processing the entire
    ** data file (don't add processing delay to the delta times).
    */
    
    locclock = time ((long *)NULL);
    bcopy(localtime ((long *)&locclock), &curtm, sizeof curtm);

    /*+
     * Need a bcmp test to ensure that the read event was not a NULL
     * event (all zeroes) as could happen if a NFS file was moved
     * while another process (e.g. display) is processing the file
     * and has it open for reading.
     */

    /*
     * Now read in a event and check severity, sender, sitename, times
     */
    while ((bufsize=read (fd, (char *)&v, sizeof(v))) == sizeof (v))
      if (bcmp(&v, &null_event, sizeof(v)) != 0)	/* Not null event  */
      {
	  if ((int)v.severity  <= minseverity)
	    if (check_strlist(&senderlist, v.sender))
	      if (check_strlist(&sitenamelist, v.site.name))
		if (check_event_time(&v))
		{
		    if (logevents)
		      eventlog(&v);
		    else
		      printf("%s", event_to_logstr(&v));
		}
      }	/* end:  if (!null event)  */

    if (bufsize == 0)			/* end of the file  */
      status = 0;
    else				/* some read error  */
      status = -1;
    return (status);	

}	/* end:  proc_datafile()  */

/*+ 
 * FUNCTION:
 * 	Check string list for matching string. Use of 'strncasecmp' looks
 * for a match from the beginning of the string, whereas 'strstr' looks
 * for a substring match but does not do ignore-case.
 */
check_strlist(slist, S)
     char **slist, *S ;	/* command line list of strings vs. EVENT string */
{
    register i = 0 ; 
    static char s[256];

    /* nothing to compare against */
    if (slist == NULL || *slist == NULL || s == NULL)
      return (1);

    while ( (s[i] =  tolower(S[i]) )  )		/* lowercase the string */
      ++i ;

    i = 0;

#ifdef DEBUG
    if (debug)
      fprintf(stderr,
	      "debug (check_strlist): checking for '%s' in list '%s'...\n",
	      s, slist[0]);
#endif
    while (slist[i])
      if (strstr(s, slist[i]) != NULL)	/* cmd line 'slist' can be substring */
/*      if (strncasecmp(s, slist[i], strlen(slist[i]))  == 0 ) /* */
      {
#ifdef DEBUG
	  fprintf(stderr, "debug (check_strlist): matched %s\n", slist[i]);
#endif
	  return (1);
      }
      else
      {
#ifdef DEBUG
	  fprintf(stderr, "debug (check_strlist): failed %s\n", slist[i]);
#endif
	  ++i ;
      }

    return(0) ;				/* failure */
}

/*+ 
 * FUNCTION:
 * 	Check event time to see if they fall in the user specified
 * command line time ranges.
**/
check_event_time(pv)
     EVENT  *pv;
{
    struct tm tm ;
    time_t eventtime ;

    bcopy (&curtm, &tm, sizeof(tm));	/* current time */

    if (tm.tm_mon < (int)pv->mon - 1)
      tm.tm_year -= 1 ;			/* previous year */

    tm.tm_mon = pv->mon - 1;	tm.tm_mday = pv->day ;
    tm.tm_hour = pv->hour ;	tm.tm_min = pv->min ;

/*    eventtime = timelocal(&tm) ;	/* Only on SunOS ? */
    eventtime = get_date(asctime(&tm), NULL); /* convert to secs since 1970 */

#ifdef DEBUG
    if (debug)
      fprintf(stderr,
	      "debug (event_time): fromtime/eventtime/totime = %ld/%ld/%ld\n",
	      fromtime, eventtime, totime);
#endif
    if (eventtime > fromtime  &&  eventtime < totime)
      return (1);
    else
      return(0);
}

