
/*
 * $Header: /nocol/src/tpmon/RCS/poll_sites.c,v 1.3 1992/06/15 17:05:13 aggarwal Exp $
 *
 * FUNCTIONS:
 *	Test throughput to a site (NOCOL style).
 *
 * poll_sites.c -- makes one pass over the entire data file
 *
 * adapted from poll_sites.c of 'pingmon' 1.15
 *
 * AUTHOR
 *	S. Spencer Sun, JvNCnet, June 1992
 *
 * $Log: poll_sites.c,v $
 * Revision 1.3  1992/06/15  17:05:13  aggarwal
 * Added '=' in the if(tp <= 0)
 *
 * Revision 1.2  1992/06/12  21:14:17  aggarwal
 * Changed the bps returned by tpmon to Kbps.
 *
 * Revision 1.1  1992/06/12  04:07:29  aggarwal
 * Initial revision
 *
 */

/* Copyright 1992 JvNCnet, Princeton */


#include "nocol.h"			/*	common structures	*/
#include "tpmon.h"			/* program specific defines */

#include <signal.h>
#include <sys/file.h>
#include <arpa/nameser.h>

/*
 * Macro to escalate the severity of a site.
 * Change E_CRITICAL to E_ERROR if you don't want this program to put
 * events in the critical state.
 */
#define ESC_SEVERITY(sev) ((sev == E_WARNING)? E_WARNING : (sev - 1))

/*
 * The level trasition at which a signal is sent to the 'watchdog' program.
 * This is called before increasing the severity in the structure, so if
 * you want that a signal should be sent when it changes from WARN -> ERROR,
 * then, check for sev = WARN. Don't set true if 'sev' is CRIT since the
 * state will not transition anymore and you don't want to send a signal
 * in each pass- only when it first changed state.
 */
#ifdef SEND_WSIGNAL
#define AT_SIGNAL_LEVEL(sev)  ((sev <= E_INFO && sev != E_WARNING) ? 1 : 0)
#endif /* SEND_WSIGNAL */

/* #defines for finish_status */
#define REACHED_EOF 1
#define READ_ERROR 2

poll_sites(fdout)
     int fdout;				/* Descriptors to open files	*/
{
  extern int debug;			/* Enable debug (in pingmon.h)	*/
  static FILE *p_cmd;			/* for creating the ping cmd	*/
  EVENT v;			    	/* described in nocol.h		*/
  char line[MAXLINE];		 	/* to create the ping command	*/
  struct tm *ltime ;    
  time_t locclock ;			/* careful: don't use 'long'	*/
  long status;		       		/* site status			*/
  int bufsize;				/* for reading in file */
  int sigpid;				/* PID of program to get signal	*/
  long tp;

  if ( lseek(fdout, (off_t)0, L_SET) == -1) { /* rewind the file	*/
    perror (prognm);
    return (-1);
  }

  /* 
   * until end of the file or erroneous data... one entire pass
   */

  while ( (bufsize = read (fdout, (char *)&v, sizeof(v))) == sizeof(v) )
  {
    /* all these default parameters are #defined in tpmon.h */
    tp = (long)throughput(v.site.addr, PORT_NUMBER, NUM_BYTES, BLOCKSIZE,
       PATTERN, RUN_TIME, debug);

    tp = tp /1000L ;			/* convert bits into Kbits */

    if (tp <= 0) /* some error occurred for this site */
    {
      v.nocop = SETF_UPDOUN(v.nocop, n_DOWN) ;	/* mark as down */
      continue;					/* keep old value */
    }

    /* Here if we have a thruput value */
    v.var.value = tp;				/* store the thruput */
    locclock = time((time_t *)NULL);		/* Grab the time	*/
    ltime = localtime ((long *)&locclock);
    v.mon = ltime->tm_mon + 1 ;	v.day = ltime->tm_mday ;
    v.hour = ltime->tm_hour   ;	v.min = ltime->tm_min  ;
    v.nocop = SETF_UPDOUN(v.nocop, n_UP) ;	/* Mark as UP */

    if (tp < v.var.threshold)		/* if bad, then raise the severity */
    {
#ifdef AT_SIGNAL_LEVEL
      if (AT_SIGNAL_LEVEL(v.severity))
        if ((sigpid = get_ppid(sigtoprog)) > 0)
        {
          kill(sigpid, SIGUSR1);  /*..send out signal to watchdog */
          if (debug)
            fprintf(stderr, "%s: sent SIGUSR1 to %d\n", prognm, sigpid);
        }
#endif /* AT_SIGNAL_LEVEL */
      v.severity = ESC_SEVERITY(v.severity);
    }
    else			/* thruput better than threshold */
      v.severity = E_INFO ;
      
    /* Now rewind to start of present record and write to the file	*/
     
    lseek(fdout,-(off_t)sizeof(v), L_INCR);
    write (fdout, (char *)&v, sizeof(v));
     
  }		/* end of:    while (read..)	*/
    
  /**** Now determine why we broke out of the above loop *****/
    
  if (bufsize == 0)			/* reached end of the file	*/
    return (1);
  else {				/* error in output data file 	*/
    fprintf (stderr, "%s: Insufficient read data in output file", prognm);
    return (-1);
  }
}		/* end of:  poll_sites		*/


/*+ 		get_ppid()
** FUNCTION:
** 	Get the pid of the process which recieves the SIGUSR1 signal.
** Simply opens the filename passed to it and reads the pid 
** from the file. Returns a zero if it gets an invalid value else it
** returns the pid of the process.
**/
get_ppid(program)
     char *program;
{
    extern int debug ;
    int fd, pid ;
    char buffer[MAXLINE];

    if (program == NULL)
    {
      if (debug)
	fprintf(stderr, "(debug) %s: (get_ppid) no program name supplied\n",
		prognm);
      return(0);
    }
    if ((fd = open(program, O_RDONLY)) < 0)
      return(0);

    if (read(fd, buffer, MAXLINE) < 0)
    {
	if (debug)
	  fprintf(stderr, 
		  "(debug) %s: (get_ppid) 'read' %s- %s\n", 
		  prognm, program, sys_errlist[errno]);
	pid = 0;
    }
    else
      sscanf(buffer, "%d", &pid);

    close(fd);
    return(pid);
}			/* end: get_ppid */
