/*
 * multiping.h -- header file for multiping.c
 */

#ifndef __PING_H__ /* __PING_H__ */
#define __PING_H__ 

#define	DEFDATALEN	(64 - 8)	/* default data length */
#define	MAXIPLEN	60
#define	MAXICMPLEN	76
#define	MAXPACKET	(65536 - 60 - 8)/* max packet size */
#define	MAXWAIT		10		/* max seconds to wait for response */
#define	NROUTES		9		/* number of record route slots */

/*
 * Macros for bitwise operations, for use in maintaining and
 * checking the duplicate table
 */
#define	A(x, bit)	(dest[x]->rcvd_tbl[(bit)>>3]) /* idtfy byte in array */
#define	B(bit)		(1 << ((bit) & 0x07))	/* identify bit in byte */
#define	SET(x, bit)	(A((x), (bit)) |= B(bit))
#define	CLR(x, bit)	(A((x), (bit)) &= (~B(bit)))
#define	TST(x, bit)	(A((x), (bit)) & B(bit))

/**************************************************************************
 This section no longer applies because I'm no longer using the upper 4
 bits to keep track of the index into the dest[] array.

#define MAXREMOTE 16  * max # remote systems that can be pinged at once *
#define WHERESHIFT 12 * # of bits to shift to extract dest. ID *
#define WHEREFROM(x)  ((x) >> WHERESHIFT)
#define SEQUENCE(dst) ((dest[dst]->ntransmitted++) | ((dst) << WHERESHIFT))
  * gives next sequence number for destination dest *
#define SEQMASK               (1 << WHERESHIFT)-1     * mask out dest. ID *
***************************************************************************/


/*
 * MAX_DUP_CHK is the number of bits in received table, i.e. the maximum
 * number of received sequence numbers we can keep track of.  Change 128
 * to 8192 for complete accuracy...
 *
 * MAXREMOTE is the max # of systems you can ping simultaneously.  This
 * number can actually be arbitrarily large but your system performance
 * will begin to suffer.  You will probably never ping anywhere close to
 * 128 sites simultaneously anyway.
 */
#define	MAX_DUP_CHK	8192
#define MAXREMOTE 256

/*
 * Define a structure to keep track internally of the various remote sites
 */
typedef struct destrec {     /* in earlier revisions, destrec.sockad was a */
  struct sockaddr_in sockad; /* struct sockaddr, in case you have problems */
  char *rcvd_tbl;
  long nreceived, 	/* # packets we got back */
       nrepeats, 	/* # packets duplicated */
       ntransmitted,	/* # packets xmitted */
       tmin,  		/* minimum round-trip time */
       tmax;		/* max RTT */
  u_long tsum;		/* sum of all RTT's */
  char hostname[MAXHOSTNAMELEN];
} destrec;

/*
 * Flags for the various command-line options
 */

#define	F_FLOOD			0x0001
#define	F_INTERVAL		0x0002
#define	F_NUMERIC		0x0004
#define	F_PINGFILLED		0x0008
#define	F_QUIET			0x0010
#define	F_RROUTE		0x0020
#define	F_SO_DEBUG		0x0040
#define	F_SO_DONTROUTE		0x0080
#define	F_VERBOSE		0x0100
#define F_TABULAR_OUTPUT	0x0200

#endif /* __PING_H__ */
