/*+ 	$Header: /nocol/src/pingmon/RCS/standalone.c,v 1.6 1992/06/18 21:15:00 aggarwal Exp $
 *
 */

/* Copyright 1992 JvNCnet, Princeton */

/*+
**
** FUNCTION:
**
**	Kill any other process and write the present PID into the
** PidFile. If cannot write to the file or if the file is locked
** by another process, it returns a value of -1 (in which case the
** calling program should EXIT).
**
** It assumes that the PidFile is "program.pid", where the pointer
** to the string "program" is passed to it.
**
** (Observe that unless the program name has been stripped of the 
**  path, the pid file is created in the same directory as the
**  program).
**
**  Method:
**		See if pid file exists, create if none
**	        try to lock
**		if cannot lock 
**		   kill process
**		   if (cannot kill)
**		     return (-1)
**		   else
**		     lock file
**		write pid, return to caller
**
** NOTE:
** 	I *do* know about the 'access' system call for the existability
** of a file. It just tended to screw up on the sun, so I used the simple
** 'fopen' call to test if the file exists.
**/

/*
 * $Log: standalone.c,v $
 * Revision 1.6  1992/06/18  21:15:00  aggarwal
 * Completely rewritten. No fancy stuff anymore (using fcntl or all
 * that).
 *
 * 
 * Revision 1.3  90/06/15  11:58:40  network
 * After sending out kill signal, wait for a while so that
 * the process can die and release the file.
 *
 */
#include <stdio.h>
#include <signal.h>				/* signal numbers	*/
#include <sys/file.h>
#include <errno.h>

#ifndef MAXLINE
#define MAXLINE	256
#endif

standalone (prognm)
     char *prognm;				/* Name of process	*/
{
    FILE *pidf ;
    int oldpid = 0, newpid = 0;
    int fd ;
    char *pidfile, hostname[MAXLINE], thishostname[MAXLINE] ;

    pidfile = (char *)malloc(strlen(prognm) + 5) ;
    sprintf(pidfile, "%s.pid\0", prognm);	/* add suffix to name	*/
    
    gethostname(thishostname, sizeof(thishostname) -1) ;
    thishostname[MAXLINE - 1] = '\0' ;

    if ( (pidf =fopen (pidfile, "r")) != NULL)	/* file exists...	*/
    {
	if (fscanf(pidf, "%d %s", &oldpid, hostname) == EOF)
	{
	    perror("(standalone) fscanf") ;		/* couldn't read */
	    return (-1);
	}
	fclose(pidf);

	if (strcmp(thishostname, hostname) != 0)	/* wrong host */
	{
	    fprintf(stderr,
		    "(standalone) %s: Program probably running on '%s'\n",
		    prognm, hostname) ;
	    fprintf(stderr, "Kill and delete '%s' file and restart\n",pidfile);
	    return (-1) ;
	}
	else					/* on proper host */
	{
	    if (kill (oldpid, SIGKILL) != 0 && errno != ESRCH)
	    {
		fprintf(stderr,
			"(standalone) %s: Couldn't kill earlier process\n",
			prognm);
		perror("signal");
		return (-1) ;
	    }
	    else
	      sleep (5) ;		/* Let other process die */
	}
    }			/* end if (pidfile could be opened) */

    /*
     * Here only if all other processes have been killed
     */

    newpid=getpid();
    if ( (pidf = fopen(pidfile, "w")) == NULL)	/* create file	*/
    {
	perror("(standalone) fopen");	
	return(-1);
    }
    fprintf (pidf,  "%d\n%s", newpid, thishostname);	/* Store present pid */
    fflush(pidf);
    fclose(pidf) ;
    fprintf(stderr, ".. locked pid-file, started new process\n");
    
    return (0) ;
}
