
#include <stdio.h>
#include <sys/types.h>
#include <arpa/nameser.h>
#include "nsmon.h"

usage()
{
  fprintf(stderr,
    "Usage: nsmon [ -d ] [ -C query class ] [ -T query type ]\n");
  fprintf(stderr, "\t[ -t timeout (secs) ] nameserver [ nameserver ...  ]\n");
  exit(1);
}

main(argc, argv)
  int argc;
  char *argv[];
{
  int class, type, timeout, ch;
  unsigned int flags;
  extern char *optarg;
  extern int optind;

  class = C_IN; type = T_SOA; timeout = 15; flags = 0;

  while ((ch = getopt(argc, argv, "AC:dT:t:")) != EOF) {
    switch (ch) {
      case 'A':
        flags |= FLAG_AAONLY; break;
      case 'C':
        class = atoi(optarg); break;
      case 'd':
        flags |= FLAG_DEBUG; break;
      case 'T':
        type = atoi(optarg); break;
      case 't':
        timeout = atoi(optarg); break;
      default:
        usage(); break;
    }
  }
  argc -= optind;
  if (argc < 1) {
    fprintf(stderr, "nsmon: no servers/requests were specified\n");
    return 1;
  }
  for (argv += optind; argc >=2; argc -=2, argv +=2) {
    printf("Server: %s  Request: %s  return code: %d\n",
      argv[0], argv[1], nsmon(argv[0], argv[1], class, type, timeout, flags));
  }
  if (argc) 
    fprintf(stderr, "nsmon: last server did not have a request\n");
  return 0;
}
