/*
 * $Header: /nocol/src/netmon/RCS/read_filter.c,v 1.1 1992/06/18 21:08:29 aggarwal Exp $
 */

/* Copyright 1992 JvNCnet, Princeton */

/*
 * Creates a new window and reads in the user entered string which is used
 * as the filter. All EVENT structures that match this pattern will then
 * be displayed by the NOCOL display program
 *
 * AUTHOR
 *	David Wagner, wagner@jvnc.net, June 8, 1992
 *
 */

/*
 * $Log: read_filter.c,v $
 * Revision 1.1  1992/06/18  21:08:29  aggarwal
 * Initial revision
 *
 */

#include "netmon.h"

#define MAXLINELEN	256			/* Max length of new pattern */
/*
 * Global variables
 */
char pattern[MAXLINELEN];		/* Save the pattern */
int isdefined_pattern=0;		/* Is pattern specified yet? */


/*+	read_filter
 ** Creates a new window and reads in a new pattern string for filtering
 ** out unwanted information.
 ** Compiles that pattern for later use by filter().
 */

read_filter()
{
  WINDOW *npatwin;				/* Where to get pattern from */

  npatwin = newwin(0,0,0,0);			/* Create new window */
  touchwin(npatwin);				/* Bring it to the front */
  wstandout(npatwin);				/* Print the title header */
  mvwprintw(npatwin, 0, (int) (COLS/2 - 9), "NEW FILTER PATTERN\n\n");
  wstandend(npatwin);

  if (isdefined_pattern) {
    /*
    ** There is a pattern compiled already - use it as the default,
    ** and let the user edit it as the starting point for a new one.
    */
    wprintw(npatwin, "Use ^U to erase filter\n");
    wprintw(npatwin, "Enter filter (<word> [&] [|] <word>..): %s", pattern);
    wrefresh(npatwin);
    get_filter(npatwin, pattern, strlen(pattern));
  } else {
    /*
    ** This is the first call to new_pattern(), so there is no
    ** saved pattern available.
    */
    wprintw(npatwin, "Use ^U to erase filter\n");
    wprintw(npatwin, "Enter filter (<word> [&] [|] <word>..): ");
    wrefresh(npatwin);
    get_filter(npatwin, pattern, 0);
  }

  if (*pattern == '\0')
    isdefined_pattern = 0;			/* clear pattern ? */
  else
  {
      isdefined_pattern = 1;			/* Remember we set pattern[] */
      wprintw(npatwin, "\n\nFilter accepted!\n");	/* Notify the user. */
  }
  wrefresh(npatwin);

  compile_pattern(pattern);			/* Defined in filter.c */
  werase(npatwin);			/* Return to the main display */
}			/* end:   read_filter */

/*
** Takes the string listed in pat[] as the starting point for a
** new pattern and allows the user to edit that one to create a new one.
** The backspace and erase keys are accepted - right now there is no
** fancy editing.
**
** Places the newly entered string into pat[] upon returning.
*/
get_filter(w, pat, patlen)
     WINDOW *w;
     char pat[MAXLINELEN];
     int patlen;
{
  int i;

  i = patlen;

  while ((pat[i]=wgetch(w)) != '\n')		/* Read one char at a time */
      if (i>0 && (pat[i]=='\b' || pat[i]==_tty.sg_erase)) {
	  wprintw(w, "\b");			/* Backspace over last char */
	  wdelch(w);				/* and delete it */
	  wrefresh(w);
	  i--;
      } else if (i < MAXLINELEN) {		/* Limit line length */
	  if (pat[i] == CTRL('u'))		/* erase line using ^u */
	  {
	      do 
		wprintw(w, "\b"), wdelch(w) ;	/* backspace to beginning */
	      while (--i) ;
	      wrefresh(w);
	      continue ;			/* get next character */
	  }
	  if (iscntrl(pat[i]))			/* Ignore ctrl chars */
	    continue ;
	  wprintw(w, "%c", pat[i++]);
	  wrefresh(w);
      } /* end of if */

  /* By the way, we are NOT in the while loop anymore */

  pat[i] = '\0';				/* Don't forget '\0'! */
}
