/*
 * $Header: /nocol/src/include/RCS/tsmon.h,v 1.5 1992/06/18 20:40:07 aggarwal Exp $
 */
#include "nocol.h"			/* inc's types.h stdio.h time.h */

#include <fcntl.h>
#include <utmp.h>
#include <string.h>
#include <sys/stat.h>

/*
** NMAX is the number of chars in a utmp name field
** LMAX is the number of chars in a utmp line field
** HMAX is the number of chars in a utmp host field
** MAX_LINES is the maximum number of lines that any terminal server will
**   ever have available
** MAX_FILENAME_LEN is the maximum length of a full pathname
** MAX_SERVERNAME_LEN is the maximum length of a terminal server name
** MAX_WTMPS is the maximum number of wtmp files to monitor concurrently
** THRESHOLD is the number of seconds to wait to ensure
**   that multiple interleaved login/logout entries from
**   the same host on the same tty line haven't happened
**   because the modem server is sending unacknowledged
**   login/logout messages to the tacacs daemon - see islogin()
** INTERVAL is the default number of seconds to sleep between eventfile updates
** DATADIR is the path to the directory where the datafile should go
** WTMP_PATH is the default path where this program will look for the
**   wtmp files listed in the configuration file
** VARNAME is a name for the variable being monitored in this program
** VARUNITS is the units used for the variable being monitored
*/

#define NMAX		sizeof(buf.ut_name)
#define LMAX		sizeof(buf.ut_line)
#define HMAX		sizeof(buf.ut_host)
#define MAX_LINES	32
#define MAX_FILENAME_LEN MAXADDRLEN
#define MAX_SERVERNAME_LEN MAXNMLEN
#define MAX_WTMPS	32
#define THRESHOLD	300
#define INTERVAL	30
#define VARNAME		"tslineusage"
#define VARUNITS	"lines"

#ifndef WTMP_PATH
#define WTMP_PATH	"/var/adm/tacacs/"
#endif

#ifndef DATADIR
#define DATADIR		"../../data"
#endif

#ifndef OUTPUT_EXTENSION
#define OUTPUT_EXTENSION "-output"
#endif

#define nameq(str)	(strncmp(buf.ut_name, (str), NMAX) == 0)
#define lineq(str)	(strncmp(buf.ut_line, (str), LMAX) == 0)
#define hosteq(str)	(strncmp(buf.ut_host, (str), HMAX) == 0)

/*
** STAT contains stuff useful for maintaining usage statistics
** STAT is used in WTMP below
** inuse is the number of tty lines that currently have someone
**   logged on through them
** totinuse records a time-weighted total of how many
**   modem lines were in use at each second
** seen is an array of wtmp entries - one element in the array for
**   each tty line that has been seen so far
** isinuse is a boolean array that belongs with seen: isinuse[i]
**   is true if the tty line in seen[i] is currently in use
** numseen is the number of tty lines that we have encountered so
**   far; that is, the number of entries in seen[]
** warnings is the total number of warning conditions that functions
**   like islogin() have encountered with this wtmp file
*/
typedef struct {
    int		inuse;
    int		totinuse;
    struct utmp	seen[MAX_LINES];
    int		isinuse[MAX_LINES];
    int		numseen;
    int		warnings;
    int		seenreboot;
} STAT;

/*
** a WTMP contains information about one wtmp file - also see STAT above
** fullfname is the full path and filename of the wtmp file
** fname is the filename of the wtmp file, which must be located in WTMP_PATH
** servername is the name of the terminal server that saves information
**   to this wtmp file
** threshold[i] is the minimum number of modem lines in use for
**   condition "i" (i.e. E_INFO, E_WARNING, E_ERROR) to be met
** lastlen records the length (in bytes) of the wtmp file
** lasttime records the timestamp of the last wtmp entry in the file
*/
typedef struct {
    char	fullfname[MAX_FILENAME_LEN];
    char	fname[MAX_FILENAME_LEN];
    char	servername[MAX_SERVERNAME_LEN];
    int		threshold[5];
    long	lastlen;
    STAT	stat;
} WTMP;

/*
** Some useful macros for debugging output
** VALUE:	DEBUGGING OUTPUT PRINTED IF debug >= VALUE:
** Silent	Only exceptional errors are printed
** PrintEvent	Each EVENT structure is printed as it is dumped to a file
** Warn		Warnings are printed as STAT->warnings is incremented,
**		  except during the first pass over the wtmp file (*)
** PrintEachWTMP Each wtmp entry is printed as it is read, except during the
**		  first pass over the wtmp file (*)
** PrintUsers	After each pass, a list of all the currently-logged on users
**		  is printed
** PrintSEEN	After each pass, the entire seen[] array is printed, except
**		  during the first pass (*)
** PrintAlways	Same as PrintSEEN, but everything is printed, even during the
**		  first pass
**
** (*) Nothing is printed during the first pass over the wtmp file because
**	most wtmp files are so huge that the first pass would yield huge
**	amounts of output, at least several megabytes for wtmps that are
**	maybe 10 Kb or 20 Kb
*/
#define Silent		0
#define PrintEvent	2
#define Warn		4
#define PrintEachWTMP	6
#define PrintUsers	8
#define PrintSEEN	10
#define PrintAlways	12


/*
** A list of all the functions that I am going to use - I guess
** this comes more out of habit, since I am used to writing ANSI C
*/
int readwtmplist(), initwtmp(), dowtmp();
int check(), dumpmsgs(), initmsgs();
int getent(), printent(), cp_entry();
int isreboot(), islogin(), islogout();

/*
** buf is a global buffer - the wtmp file is read one entry at a
**   time into buf, and all functions use buf as their input
** fd is the file descriptor for the wtmp file
** wtmps[] is a list of wtmp files to monitor and some saved information
**   about them
** numwtmps is the number of wtmp files to monitor
** eventlist[] is a list of EVENT structure that will be dumped to a file
**   so that netmon can see them
** datafile[] is the full path to the output file
** debug controls the amount of debugging output
** optarg and optind are external variables for use with getopt()
*/
struct utmp buf;
int fd;
WTMP wtmps[MAX_WTMPS];
int numwtmps;
EVENT *eventlist;
char datafile[MAX_FILENAME_LEN];
int debug;
extern char *optarg;
extern int optind;
