/*
 * $Header: /nocol/src/include/RCS/trapmon.h,v 1.5 1992/06/11 06:45:20 aggarwal Exp $
 */

#include <sys/types.h>
#include <netinet/in.h>
#include <stdio.h>
#include <time.h>
#include <sys/time.h>
#include <errno.h>
#include <syslog.h>
#include <fcntl.h>
#include <string.h>
#include <sys/socket.h>
#include <netdb.h>

#include "snmp.h"
#include "snmp_impl.h"
#include "asn1.h"
#include "snmp_api.h"
#include "snmp_client.h"

#include "nocol.h"				/* For O_NETMON output */


#ifdef BSD4_3					/* BSD4.3 already has these */
#define HAVE_FD_MACROS
#endif

/* Macros for use with snmp_select_info() and select() */
#ifndef HAVE_FD_MACROS
typedef long    fd_mask;
#define NFDBITS (sizeof(fd_mask) * NBBY)        /* bits per mask */
#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)      bzero((char *)(p), sizeof(*(p)))
#endif /*end of #ifdef HAVE_FD_MACROS */

/* These #define's handle 4.2 systems without additional syslog facilities. */
#ifndef LOG_CONS
#define LOG_CONS        0       /* Don't bother if not defined... */
#endif
#ifndef LOG_LOCAL0
#define LOG_LOCAL0      0
#endif


/* Output data dir for the NOCOL style output */
#ifndef DATADIR
#define DATADIR		"../../data"
#endif

/*
** SNMP_TRAP_MAX is the largest valid SNMP_TRAP_* number
** SNMP_TRAP_MAX + 1 is the canonical unknown/invalid trap number
** This really belongs in "snmp.h" with the SNMP_TRAP_* define's there
#define SNMP_TRAP_MAX	0x6

/*
 * Describe all the possible traps here and their severity levels here.
 * Note that the location of the traps in the array depends on the int
 * value assigned to the various trap types in 'snmp.h'
 */

struct t_desc {
    char  *tname ;		/* Trap name */
    int   tseverity ;		/* Trap severity as described in nocol.h */
    char  *tseverity_str ;	/* Severity description strings */
} ;

struct t_desc trap_desc[] = {
  { "Cold Start", E_WARNING, "Warning" },		/* trap 0 */
  { "Warm Start", E_WARNING, "Warning" },		/* trap 1 */
  { "Link Down",  E_ERROR,   "ERROR" },			/* trap 2 */
  { "Link Up",    E_ERROR,   "ERROR" },			/* trap 3 */
  { "Authentication Failure", E_INFO, "Info" },		/* trap 4 */
  { "EGP Neighbor Loss", E_CRITICAL, "CRITICAL" },	/* trap 5 */
  { "Enterprise Specific", E_WARNING, "Warning" },	/* trap 6 */
  { "Unknown Type", E_WARNING, "Warning" }	     	/* trap 7 */
} ;



/*
** Possible options:
**  O_NETMON:	output EVENT structures to file for use with netmon
**  O_LOG:	output to syslog()
**  O_PRINT:	output to stderr
**  O_DEBUG:	debugging output to stdout
** See the 'options' global variable below
*/
#define O_NETMON	0x1
#define O_LOG		0x2
#define O_PRINT		0x4
#define O_DEBUG		0x8

/*
 * Timeout for each EVENT in seconds - currently set to 30 minutes.
 * Trap events older than this will be deleted from the data file.
 */
#define TIME_TO_LIVE	(30*60)		/* convert to seconds */

/* Timeout for select() in seconds - currently set to 5 minutes */
#define SELECT_TIMEOUT	(5*60)

#define MAX_PATH_LEN	256			/* Longest path expected */
#define DATAFILE_MODE	0664			/* Mode for EVENT file */
#define OUTPUT_EXTENSION "-output"		/* Extension for EVENT file */
#define MAX_TRAPS	256			/* Max # of unresolved traps */

extern int	errno;
int		snmp_dump_packet = 0;
int		options;			/* Command line options */
char		*progname;			/* Program name, no path */
char		datafname[MAX_PATH_LEN];	/* Filename for O_NETMON */
time_t		die_at[MAX_TRAPS];		/* When this EVENT times out */
int		numtraps;			/* # of outstanding EVENTs */
