/*
 * $Header: /nocol/src/include/RCS/tpmon.h,v 1.1 1992/06/12 21:08:20 aggarwal Exp $
 */
#ifndef __TPMON_H__
#define __TPMON_H__


/*
 *		FILE DEFINITIONS
 *
 * DATADIR is the location of the datafile. The name is prepended to
 * the programs own name to create the output filename.
 *
 * NODESFILE is the full name of the thruput config file
 * and ip addresses.
 *
 */

#ifndef DATADIR
#define DATADIR		"../../data"
#endif

#ifndef NODESFILE
#define NODESFILE	"../../etc/tpmon-confg"
#endif

/*
 * The progam automatically fills in its own name in the EVENT.sender
 * field. If you want to over-ride this name with your own, then define
 * SENDER
 */
/* #define SENDER	"thruputmon"	/* About 16 characters possible ? */

/*
 * Extension of the output datafile. DATADIR/prognm is tacked onto this name.
 */
#define	TPMONOUTPUTEXT  "-output"

/*
 *		CONSTANTS
 */
#ifndef BUFSIZ		      		/* in stdio.h */
#define BUFSIZ 1024
#endif /* BUFSIZ */

#define MAXLINE		127	/* Randomly selected string lengths */

#define VARNM		"Thruput"	/* for EVENT.var.name field	*/
#define VARUNITS	"Kbps"		/* Units name */
#define DEBUG_FLG 	"TPMON_DEBUG" 	/* to run in debug mode	if set	*/
#define POLLINTERVAL	(time_t)(2 * 3600)	/* interval between queries */

#define PORT_NUMBER	9		/* tcp discard port */
#define NUM_BYTES	0L		/* default num_blocks */
#ifdef BUFSIZ	/* in stdio.h */
#define BLOCKSIZE 	BUFSIZ		/* default blocksize */
#endif /* BUFSIZ */
#define PATTERN		NULL		/* default pattern == none == random */
#define RUN_TIME	30		/* default secs of test run */
  /* see below for the effects of having both time and blocksize non-zero */

/*
 * Global variables
 */
#ifdef GLOBALS
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN int debug;
EXTERN time_t pollinterval;		/* Time between polls */
EXTERN char *prognm;			/* Program name			*/
EXTERN char *sender;			/* Name used in the v.sender field */
EXTERN char ipnodes[MAXLINE];		/* File with the list of nodes	*/
EXTERN char datafile[MAXLINE] ;		/* Name of the data file	*/
EXTERN char sigtoprog[MAXLINE] ;	/* Prog recieving SIGUSR1 sig when */
                                        /* a site goes critical */

/*
 * throughput -- finds throughput of a remote site
 *
 * parameters:
 *   addr is the address of the site to be tested.  It can be either
 *     a name (e.g. phoenix.princeton.edu) or an IP # (e.g. 128.112.128.43)
 *   port is the port number, and defaults to 9 (discard port)
 *   numblocks is the number of blocks to send
 *   blocksize is the blocksize to be used
 *   pattern is a pattern of bytes which will be used to fill the data block
 *     (set it to NULL for random characters)
 *   time is the duration of the test in seconds
 *   verbose enables verbose output mode
 *
 *   if both numblocks and time are nonzero, then the test will last until
 *   either numblocks blocks have been sent, or time seconds have elapsed,
 *   whichever comes first
 *
 * return values:
 *   a double representing the throughput in bits per second
 *   -1.0 if an error occured
 */

double throughput(/* char *addr, short int port, long numbytes, int blocksize,
                  char *pattern, int time, int verbose */);

#endif /* __TPMON__H__ */


