/*	$Header: /nocol/src/include/RCS/nocol.h,v 1.11 1992/06/18 20:40:07 aggarwal Exp $	*/

/* Copyright 1992 JvNCnet, Princeton */

/*************************/
/* 	NOCOL.H          /
/***********************/

/* need these include files for inet routines */
#include <sys/types.h>
#include <stdio.h>
#include <errno.h>			/* doesn't define sys_errlist */
#ifdef NeXT
#  include <sys/malloc.h>
#else
#  include <malloc.h>
#  include <unistd.h>                             /* for access()         */
#endif	/* NeXT */
#include <time.h>
#include <sys/time.h>
#ifdef sun
#  include <sys/socket.h>
#endif
#include <netinet/in.h>
#include <arpa/inet.h>

extern char *sys_errlist[] ;

typedef char BYTE;		/* an 8-bit field */

#define MAXPROGNM	12	/* Name of monitoring program */
#define	MAXNMLEN	16	/* For site's name, can be nickname */
#define MAXADDRLEN	127	/* Ok for IP, decnet, OSI */
#define MAXCOMMENT	16	/* For comments that the programs might have */

/* data structure of NOCOL event message */

/* site identifier */
typedef struct 
{
    char	name[MAXNMLEN];		/* site name (can also be a pseudo) */ 
    char	addr[MAXADDRLEN];	/* Okay for IP, DECnet, OSI */
} SITE;	

/* problem identifier */
/* typedef struct
/* {
/*	unsigned char	class:8;	 problem class */
/*	short 		id;		 problem id from 001 to 999
/*					 for each class */
/* } PROB;
*/

/* variable info */
typedef struct
{
    char	name[MAXNMLEN];		/* name or keyword of variable */
    u_long	value;			/* variable value */
    u_long	threshold;		/* variable threshold, if applicable */
    char	units[8];		/* units of variable (pkts, ms) */
} VAR;

/* event format */
typedef struct 
{
    char	sender[MAXPROGNM];	/* 8 bytes of sender name */
    unsigned char	mon:8;		/* 1 to 12; can be reduced to 4 bits */
    unsigned char	day:8;		/* 1 to 31; can be reduced to 5 bits */
    unsigned char	hour:8;		/* 0 to 23; can be reduced to 5 bits */
    unsigned char	min:8;		/* 0 to 59; can be reduced to 6 bits */
    unsigned char	severity:8;	/* event severity; need only 2 bits */
    unsigned char	nocop:8;	/* operations flag indicating STATE */
    SITE		site;		/* site identifier */
    VAR			var;		/* variable info */
/*    char	comment[MAXCOMMENT];	/* Generic comment, for future... */
} EVENT;

/* Event severities. */
#define E_CRITICAL	1
#define E_ERROR		2
#define E_WARNING	3
#define E_INFO		4
	
/* 'nocop' flags indicating various 'STATE's that a site can be in */

#define n_UP		0x01
#define n_DOWN		0x02
#define n_UNKNOWN	0x04			/* not tested yet ? */
#define n_TEST		0x08			/* Site in test mode */
#define n_NODISPLAY	0x10			/* Ignore while displaying */

/*
 * Some flag operations on mask 'm'. Since UP, DOWN, UNKNOWN are mutually
 * exclusive, this macro sets the desired mask and clears the others
 * (No, the DOUN is not a typo, it stands for DOwn and UNknown
 */
#define SETF_UPDOUN(mask, f)	( (mask & ~(n_UP | n_DOWN | n_UNKNOWN)) | f )
