/*
 * $Header: /noc/network/netlog/src/RCS/search_logs.c,v 2.1 1992/06/01 19:40:00 aggarwal Exp $
 */

/*+
 ** Search ALL the logs for any given regular expression. Uses the
 ** program GREPREC to do so.
 **
 ** Vikas Aggarwal, vikas@jvnc.net
 **/

/*
 * Copyright 1992 JvNCnet, Princeton University
 */

/*
 *	$Log: search_logs.c,v $
 * Revision 2.1  1992/06/01  19:40:00  aggarwal
 * Corrected parenthesis in the get_reply()
 *
 * Revision 2.0  1992/05/10  16:31:11  aggarwal
 * Cleaned up and restructured for releasing 'netlog v2.0'
 *
 * Revision 1.1  1990/03/05  14:44:07  aggarwal
 * Initial revision
 *
 */

#ifndef lint
  static char rcsid[] = "$RCSfile: search_logs.c,v $ $Revision: 2.1 $ $Date: 1992/06/01 19:40:00 $" ;
#endif

#include "netlog.h"

search_logs()
{
    char grepcmd[BUFSIZ * 2], srchexpr[MAXLINE], logfiles[MAXLINE] ;
    char outf[MAXLINE];
    char *junk ;

    bzero (srchexpr, sizeof(srchexpr)) ;
    printf("\n\n\t\t%s\n\n", "** Netlog Search **");

    /*
     * Small blurb about the regular expression types...
     */
    printf("Regular expressions:\n") ;
    printf(" A regular expr is zero or more branches, separated  by '|'\n") ;
    printf(" '*'  a sequence of 0 or more  occurrences\n") ;
    printf(" '+'  a sequence of 1 or more occurrences\n") ;
    printf(" '?'  a single match or NULL string\n") ;
    printf(" '^' for beginning of line, '$' for end of line\n") ;
    printf(" '[]' is a range of characters that are to be matched\n\n") ;

    strncpy(srchexpr, 
	    get_reply("Enter reg expr to search", (char *)NULL, C_ANY),
	    MAXLINE - 1 ) ;

    printf("You can enter a shell type of expression for the dates in\n");
    printf("which the search is to be performed (0[56]2[3-9]92 or 05*92)\n\n");
    strncpy(logfiles, get_reply("Enter log dates (as mmddyy) to search in",
				"*", C_DIGIT | C_ALPHA | C_PUNCT),
	    MAXLINE - 1) ;
    
 again:
    strncpy(outf, get_reply("Enter output file", "/dev/tty",
	    C_DIGIT | C_ALPHA | C_PUNCT), MAXLINE - 1);

    /*
     * Make sure user gives full path
     */
    if (outf[0] != '/')
    {
	printf("Error: Please give full pathname while specifying file\n");
	goto again;
    }

    if (strncmp(outf, "/dev/tty", strlen("/dev/tty")) != 0)
      if (access(outf, F_OK) == 0) 	/* file already exists */
      {
	  printf("'%s' already exists and will be overwritten! ", outf) ;
	  junk = get_reply("Overwrite (y/n) [n]", "n", C_ALPHA) ;
	  if ( toupper(*junk) != 'Y' )
	    goto again ;
      }

    if (strcmp(outf, "/dev/tty") == 0)
          sprintf(grepcmd, "%s -i -s '%s' -e '%s' '%s'  %s/*/*.%s | %s\0",
		  GREPREC, RECSEP, RECSEP, srchexpr, LOGDIR, logfiles, MORE) ;
    else
      sprintf(grepcmd, "%s -i -o %s -s '%s' -e '%s' '%s'  %s/*/*.%s >> %s\0",
	      GREPREC,outf, RECSEP, RECSEP, srchexpr, LOGDIR,logfiles, outf );

    if (debug)
      printf("(debug): system(%s)\n", grepcmd) ;
    else
      return(system(grepcmd));

}		/* end:  search_logs	*/
