.\" $Header: /noc/network/netlog/src/RCS/netlog.man,v 1.3 1992/06/01 19:20:23 aggarwal Exp $
.\"
.TH netlog 1 "May 1, 1992"
.SH NAME
netlog \- Unix based Trouble Ticketing system
.SH SYNOPSIS
.LP
.B netlog
[
.I option
]
.LP
where
.I option
is one of
.TP
.B C
to  \fIcreate\fR an entry
.TP
.B E
to \fIedit\fR the log for any date
.TP
.B R
to \fIread\fR the log for any date
.TP
.B I
for \fIindexing\fR utilities
.TP
.B L
for \fIlisting\fR all open tickets
.TP
.B S
to \fIsearch\fR for any keyword and print that entry
.TP
.B P
to \fIprocess\fR tickets (print logical sequence of entries for any ticket)
.TP
.B Q
to \fIquit\fR netlog
.SH DESCRIPTION
.LP
.B netlog
is a simple trouble ticketing system based on an 
.I Open
ticket,
.I Update
ticket, 
.I Close
ticket mechanism. The program runs on Unix systems, is
.I not
based on any database, stores all logs as ASCII text files. There is no
restriction on the length of a log entry. The menu presented by invoking
.B netlog
is the user's access mechanism to reading, updating or processing trouble
tickets.
.LP
All \fBnetlog\fR  entries are categorized as OPEN, UPDATE, CLOSE or
INFORMATIONAL.
.IP OPEN
A ticket is \fIopened\fR on a particular problem when it is unresolved at the
time of creating the entry. 
A unique ticket number is automatically assigned to the entry and the entry
is also added to the list of open tickets.
The time and initials of the user making the entry are prompted for. Default
values are also indicated. The default initials are looked up in the file
.B initials
which is maintained by the program administrator \fBI_OWNER\fR.
.IP UPDATE
An \fIupdate\fR is made to an Open ticket whenever any additional 
information is available about the open ticket, but the problem has not been
resolved. The list of open tickets is displayed and the user is asked to
enter the open ticket number from the list of open tickets.
.IP CLOSE
An trouble ticket is \fIclosed\fR whenever the problem is resolved. The
corresponding entry is also deleted from the list of open tickets. This entry
should attempt to summarize the problem so that it can be used in easy report
generation later.
.IP INFO
Any ticket entry that is strictly for informational purposes is classified as
an \fIinformational\fR ticket. A unique ticket number is automatically
assigned  to the ticket.
.\" ******************************** ************************************
.SH USING NETLOG
.LP
.B netlog
is user friendly and most of the responses are self explanatory. 
Default responses (whenever available) are shown within square brackets and
can be selected simply by hitting a RETURN. Most of the errors are also
detailed and self explanatory. Upon invocation, a menu of available options
is displayed. The current selection is highlighted (and also has an asterix
in front of it for dumb terminals). An option can be selected by either
entering the first character of an option, or by using the arrow keys ( 
.I control-P
and
.I control-N 
also work). Hit RETURN to enter a selection.
.LP
.IP Create
Only users belonging to one of the groups-
.I WRITE_GROUPS
can create netlog entries.
If prompted for the initials, enter a max of 3 digits for your initials. The
time is entered in the format:
.I hhmm
(for hour and minute). Default responses are indicated within square
brackets. The default editor is \fIvi\fR, but the environment variable VISUAL
overrides this value.
.IP
Once the entry is created, the user is prompted for email addresses for
mailing out the newly created entry. Formatting and updating of the entry is
done  in the background via a forked process. \fI In the event that the entry
cannot be updated to the logs, it is mailed out to the user and the
maintainer with the subject line indicating the error message \fR.
.IP Edit
Use this option to edit the log files for any date. This option should be
used with care and 
.I not
for deleting entries since the index file contains references to the logs and
must be rebuilt if changes are made to the logs manually.
When prompted for the month, day, year, enter
.I two
digit values (use '09' instead of '9', etc.).
.IP Read
Use to read the logfile for any date. When prompted for the month, day, year,
enter 
.I two
digit values (use '09' instead of '9', etc.).
.IP Index
Used by the administrator for maintenance of the index file.
.IP List
This option is used to display the list of open tickets.
.IP Search
Use this to search the logs for any regular expression and display the ticket
entry. This option uses
.B grep_record
to do the searching. By default, all log files are searched. The list of
files to be searched can be made more specific using shell type wildcarding
of the filenames when prompted.
.IP Process
Since entries are made and stored depending on the date that they were made
and \fInot\fR based on the ticket number, this option is useful for
extracting all entries made for a particular ticket (or range of tickets) in
sequential order.
.\" ***************************  ******************************
.SH NOTES
.LP
.TP
.B 1)
The date cannot be altered while making an entry. The current date  is
automatically used.
.TP
.B 2)
The default editor is \fIvi\fR. However, the editor can be changed by setting
the environment variable \fIVISUAL\fR in your shell.
.TP
.B 3)
The \fIIndex Utilities\fR option manipulates the index file (which keeps
track of ticket numbers and dates an entry was made). This option can only
be run by the owner of the executable \fBI_OWNER\fR.
.TP
.B 4)
The program employs file locking while updating to prevent conflicts. In case
it cannot lock an essential file for any reason, a newly created entry is
saved by mailing it out to the creator of the ticket as well as to the
maintainer of the software. Error messages are displayed on the user's
terminal.
To clear out a lock (in case of a system reboot or remote dead
.BR lockd ),
simply delete the lock files in the LOCKDIR.
.SH AUTHOR
Vikas Aggarwal, JvNCnet, (vikas@jvnc.net)
.SH SEE ALSO
grep_record(1), netlog(8)
