/*+ 
 * $Header: /noc/network/netlog/src/RCS/netlog.c,v 2.1 1992/05/18 16:28:50 aggarwal Exp $
 */

/*+ 
 ** This is the main module of NETLOG. NETLOG was written to keep track
 ** of all network events in the way of a simple OPEN ticket, CLOSE
 ** ticket mechanism.
 **
 ** Why didn't I use a simple database ?? Aha, for 1) databases are not
 ** exactly simple. for 2) Oracle costs bucks and Ingres is a mess
 ** (ryhmes well together, don't it ??) 3) nice to have a simple
 ** flat Unix file where I can dive into and read logs without having
 ** to write any program which even remotely resembles the mystic
 ** spaghetti of Cobol like code. for 4) human C programmers can
 ** maintain the code without having to be C AND dbase wizards.
 **
 ** Notwithstanding, databases are fast (once they start up). In an
 ** attempt to speed up this humanly code, I have done the following:
 **	1) use the 'grep/egrep' algorithms for searching records
 **	2) keep an index of ticket numbers in an ticket-index file.
 **	   This file is of the format:  (ticket  file file file ).
 **	3) used curses for a user freudly interface.
 **
 ** AUTHOR:
 **	Vikas Aggarwal, vikas@jvnc.net, March 1990
 */

/* Copyright 1992 JvNCnet, Princeton University

   Permission to use, copy, modify and distribute this software and its
   documentation for any purpose is hereby granted without fee, provided
   that the above copyright notice appear in all copies and that both
   that copyright notice and this permission notice appear in supporting
   documentation, and that the name of JvNCnet or Princeton University
   not be used in advertising or publicity pertaining to distribution of
   the software without specific, written prior permission.  Princeton
   University makes no representations about the suitability of this
   software for any purpose.  It is provided "as is" without express or
   implied warranty.
   
   PRINCETON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
   FITNESS. IN NO EVENT SHALL PRINCETON UNIVERSITY BE LIABLE FOR ANY
   DAMAGES WHATSOEVER, INCLUDING DAMAGES RESULTING FROM LOSS OF USE, DATA
   OR PROFITS, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
   CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/*
 *	$Log: netlog.c,v $
 * Revision 2.1  1992/05/18  16:28:50  aggarwal
 * Changed the order of the netlog menu options.
 *
 * Revision 2.0  1992/05/10  16:45:06  aggarwal
 * Cleaned up and restructured for releasing netlog v2.0
 *
 *
 * Revision 1.3  90/03/01  17:50:25  network
 * There was no shared locking for the BSD system in lock-file.
 * Added shared locking if user wanted a "r" lock on the file.
 * 
 * Revision 1.1  90/03/01  14:32:06  aggarwal
 * Initial revision
 * 
 *
 */
/*  */

#ifndef lint
 static char rcsid[] = "$RCSfile: netlog.c,v $ $Revision: 2.1 $ $Date: 1992/05/18 16:28:50 $" ;
#endif


#include "netlog.h"
#include "version.h"
#include <signal.h>

static char *mtitle = "NETLOG MAIN MENU\0" ;	/* needed for menu() */
static char *options[] = {		/* ensure that first char is unique */
    "Create an entry",
    "List open tickets", "Read log",
    "Search for an entry", "Process ticket(s)",
    "Edit log", "Index Utilities",
    "Quit", ""				/* last entry is null string	*/
  } ;				/* if changing, only modify controller	*/

/* Init all the global string variables */
char *good_terminals[] =  { GOODTERMINALS, "" } ;
char *bad_terminals[]  =  { BADTERMINALS,  "" } ;

char *exec_files[]  = { NROFF, EDITOR, EGREP, GREPREC, MORE, COPY, 
			  CAT, MAIL, "" } ;
char *read_files[]  = { ETCDIR, LOGDIR, LOCKDIR, 
			  INDEXFILE, NETLOGHDR, NROFFHDR, "" } ;
char *write_dirs[]  = { ETCDIR, LOGDIR, LOCKDIR, "" } ;
char *write_files[] = { INDEXFILE, OPENTICKETS, "" } ; /* bare minimum files */

char *netlog_owner = NETLOGOWNER ;
char *write_groups[] = { WRITE_GROUPS, "" } ;

char *months[] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" } ;

    
main(ac, av)
     int ac;
     char **av;
{
    extern char *prognm ;		/* in netlog.h */
    extern char *optarg ;
    extern int optind, opterr ;
    int c ;
    void done() ;			/* predeclared for signal() */

    if ( (prognm = (char *)strrchr (av[0], '/')) == NULL )
      prognm = *av;			/* Store program name without path */
    else
      prognm++ ;			/* skip the leading '/' */
    
    signal(SIGHUP, done);
    signal(SIGQUIT, done);


    while ( (c = getopt(ac, av, "d")) != EOF)
      switch (c)
      {
       case 'd':
	  debug = 1 ;
	  fprintf(stderr, "%s version= %s\n", prognm, version) ;
#ifndef DEBUG
	  fprintf(stderr, "(%s) WARNING: Program not compiled with DEBUG\n",
		  prognm);
	  debug = 0 ;			/* Don't allow debug mode */
#endif
	  break ;
       case '?':
       default:
	  fprintf (stderr, "Unknown flag: %c\n", optarg);
	  fprintf (stderr, "Usage: %s [-d (debug)]\n", prognm);
	  exit (1);
	  break ;
      }		/* end switch	*/

    /* Rest should all be command line options for netlog options	*/
    ac = ac - optind ;		/* update arg count remaining */
    while (optind--)
      ++av ;			/* update argv */

    cmdline_options = av ;	/* global for using in all modules */
    num_cmdoptions = ac ;	/* global remaining options */

    umask (NETUMASK) ;		/* For the entire proc	*/

    if (chdir(TOPDIR) == -1)	/* All files are defined relative ..	*/
    {			      	/* .. to the topmost directory.		*/
	fprintf(stderr, "(%s) chdir ", prognm);
	perror(TOPDIR);
	exit (1);
    }

    if (init() == -1)			/* check environ + file access	*/
    {
	fprintf (stderr, "netlog: Fatal error in init, exiting..\n");
	exit (1) ;
    }

    if (debug)				/* allow debug info to be viewed */
    {
	fprintf (stderr, "Hit RETURN to continue: ");
	getchar() ;
    }

    for (; ;)
    {
	char c ;				/* desired selection	*/

	if ( *cmdline_options == NULL )		/* no more cmd line arg	*/
	  c = menu(options, mtitle, "Enter option: ") ;
	else
	  c = **cmdline_options++ ;		/* take option from  cmdline */

	controller(c);
	printf ("\n\tNETLOG: Hit RETURN to continue: ");
	getchar();
    }			/* end for */
}		/* end:  main() */


/*+ 		controller
 ** FUNCTION:
 ** 	To call the respective function based on the user's selection
 ** Dependant on the 'options' structure.
 **/
controller(c)
     char c ;				/* user's selection	*/
{
    void done();

    switch (toupper(c))
    {
     case 'C':				/* create a new entry	*/
	if (in_write_group)
	  create_entry();
	else
	  fprintf(stderr,
		  "(%s): Permission denied (not in any write group)\n",
		  prognm);
	
	break;
     case 'E':
	if (in_write_group)
	  edit_log();
	else
	  fprintf(stderr,
		  "(%s): Permission denied (not in any write group)\n",
		  prognm);
	break ;
     case 'I':		 		/* index utilities */
	system(INDEXMAIN) ;
	break;
     case 'L':
	list_open_tkts() ;
	break ;
     case 'P':				/* process_tickets */
	process_tickets();
	break ;
     case 'Q':				/* quit */
	done();
	break;
     case 'R':				/* read logs */
	read_log();
	break;
     case 'S':				/* search logs */
	search_logs();
	break;
     default:
	fprintf(stderr,"controller: Uh oh, got unexpected option: %c ", c);
	fprintf(stderr, "(Guess 'menu' slipped\n)") ;
	break ;
    }					/* end switch		*/
}					/* end controller	*/



/*+ 		done
 ** FUNCTION:
 ** 	Clean up all files before leaving. Unlock files that may be locked.
 +*/

void done()
{
    if (cookie()  == 1)
      printf("Uh oh, sticky cookie jar\n") ;

    exit (0) ;
}
