/*
** $Header: /noc/network/netlog/src/RCS/edit_log.c,v 2.0 1992/05/10 16:28:26 aggarwal Exp $
*/

/* Copyright 1992 JvNCnet, Princeton University */

/*+ 
** FUNCTION:
** 	Edit logfile for any date. Let the intelligent shell take care
** of multiple files.
**/

/*
 *      $Log: edit_log.c,v $
 * Revision 2.0  1992/05/10  16:28:26  aggarwal
 * Cleaned up and restructured for releasing 'netlog v2.0'
 *
 * Revision 1.1  1990/03/05  14:44:07  network
 * Initial revision
 *
 */

#ifndef lint
  static char rcsid[] = "$RCSfile: edit_log.c,v $ $Revision: 2.0 $ $Date: 1992/05/10 16:28:26 $" ;
#endif

#include "netlog.h"

edit_log()
{
    char *reply, syscmd[BUFSIZ * 2], temp[MAXLINE],
         da[MAXWORD], mo[MAXWORD], yr[MAXWORD] ;
    time_t stamp ;				/* for getting the time	*/
    struct tm *timest ;				/* returned pointer	*/

    da[MAXWORD -1] = '\0' , mo[MAXWORD -1] = '\0' , yr[MAXWORD -1] = '\0' ;
    stamp = time((long *)NULL);
    timest = localtime ((long *)&stamp) ;

    printf("\n\n\t\t%s\n\n", "** Edit Logfile **");

    sprintf(da, "%02d\0", timest->tm_mday);	
    sprintf(mo, "%02d\0", (timest->tm_mon + 1));	
    sprintf(yr, "%02d\0", timest->tm_year);	

    strncpy(mo, get_reply("Enter..\t month", mo, C_DIGIT), MAXWORD -1) ;
    strncpy(da, get_reply("\t date(s)", da, C_DIGIT), MAXWORD -1);
    strncpy(yr, get_reply("\t year", yr, C_DIGIT), MAXWORD -1);
    
    sprintf(temp, "%s/%s%s/netlog.%s%s%s", LOGDIR, mo, yr, mo, da, yr) ;

    if (access(temp, W_OK) != 0)	/* no write access on file */
    {
	fprintf(stderr, "(edit_log): Error in write access\n");
	perror(temp) ;
	return (-1) ;
    }

    sprintf (syscmd, "%s %s\0", editor, temp) ;
    
    if (debug)
      printf("(debug): system(%s)\n", syscmd) ;
    else
      return (system(syscmd)) ;

}		/* end: edit_log */
