#include "globals.h"

main(argc, argv)
int argc;
char *argv[];
{
	char request[256], reply[256];
	char hostname[64], msg[64], local_user[64], remote_user[64], directory[128], object[64], start[32], end[32], hostfile[256];
	char *key;
	int status;
	time_t now, yesterday, hours;
	struct tm *gmt;
	struct passwd *pw;
	int c;
	float less, greater;
        
        ghead = NULL;
	eflag = hflag = sflag = uflag = oflag = pflag = mflag = vflag = FALSE;
	Argv = argv;
	Argc = argc;
	pw = getpwuid(geteuid());
	strcpy(local_user, pw->pw_name);
	strcpy(remote_user, pw->pw_name);
	strcpy(directory, DEFAULT_DIRECTORY);
        strcpy(hostfile, DEFAULT_FILE);
	strcpy(object, DEFAULT_OBJECT);
	hours = DEFAULT_HOURS;

	for (c = 0; c < 128; c++)
		utol[c] = c;

	for (c = 'A'; c <= 'Z'; c++)
		utol[c] = c - 'A' + 'a';

	/*
	 * Parse command line arguments.
	 */
	outfp = stdout;
	while ((c = getopt (argc, argv, "e:h:s:l:u:o:p:m:v")) != EOF)
	{
		switch(c)
		{
			case 'e':
				eflag = TRUE;
				strcpy(end, optarg);
				break;
			case 'h':
				if (sflag)
				{
					fprintf(stderr, "%s: can't use -h and -s together.", argv[0]);
					exit(1);
				}
				hflag = TRUE;
				hours = atoi(optarg);
				break;
			case 's':
				if (hflag)
				{
					fprintf(stderr, "%s: can't use -h and -s together.", argv[0]);
					exit(1);
				}
				sflag = TRUE;
				strcpy(start, optarg);
				break;
			case 'l':
	                        strcpy(remote_user, optarg);
				lflag = TRUE;
				break;
                        case 'u':
                                less = (float) atof(optarg);
                                if ((strspn(optarg, RANGE) != strlen(optarg)) || (less <= (float) 0)) {
                                   fprintf(stderr, "%s: range error\n", optarg);
                                   exit(1);
                                };
                                uflag = TRUE;
                                break;
                        case 'o':
                                greater = (float) atof(optarg);
                                if ((strspn(optarg, RANGE) != strlen(optarg)) || (greater >= (float) 100)) {
                                   fprintf(stderr, "%s: range error\n", optarg);
                                   exit(1);
                                };
                                oflag = TRUE;
                                break;
                        case 'p':
                                strncpy(pattern, optarg, 35);
                                pflag = TRUE;
                                break;
                        case 'm':
                                mflag = TRUE;
                                strcpy(new_server, optarg);
                                break;
                        case 'v':
                                vflag = TRUE;
                                break;
			default:
				fprintf(stderr, "usage: %s <-h hours> <-s start> <-e end> <-l user> <-u under> <-o over> <-p pattern> <-m machine>\n", Argv[0]);
				exit(1);
		}
	}

	status = open_connection(&readfp, &writefp);
	if (status < 0)
	{
		fprintf(stderr, "Connection failed.\n");
		exit(1);
	}

	/*
	 * Pass authentication.
	 */
	fread(reply, 1, strlen("login: "), readfp);
	fprintf(writefp, "%s %s\n", remote_user, local_user);
	fflush(writefp);
	fread(reply, 1, strlen("Password:"), readfp);
	if (strncmp(reply, "Password:", strlen("Password:")) == 0)
	{
		gethostname(hostname, sizeof(hostname));
		printf("(Warning: %s or %s is not in %s's .rhost file on %s.)\n",
			hostname, local_user, remote_user, server_name);
		fflush(stdout);
		fread(reply, 1, 3, readfp);	/* IAC WILL ECHO */
		fprintf(writefp, "%c%c%c", IAC, DO, ECHO);
		fflush(writefp);
		sprintf(msg, "%s's password:", remote_user);
		key = getpass(msg);
		fprintf(writefp, "%s\n", key);
		fflush(writefp);
		fread(reply, 1, 3, readfp);	/* IAC WONT ECHO */
		fprintf(writefp, "%c%c%c", IAC, DONT, ECHO);
		fflush(writefp);
	}

	/*
	 * Ignore startup banner.
	 */
	query("");
	if (!sflag)
	{
		now = time(0);
		yesterday = now - hours*SECS_PER_HOUR;
		gmt = gmtime(&yesterday);
		sprintf(start, "%02d%02d%02d%02d%02d%02d",
			gmt->tm_year, gmt->tm_mon + 1, gmt->tm_mday,
			gmt->tm_hour, gmt->tm_min, gmt->tm_sec);
	}
	if (!eflag)
	{
		strcpy(end, "now");
	}

        minute = get_minute(start, end, hours);
	sprintf(request, "cd %s", directory);
	VPRINTF("%s\n", request);
	query(request);
	sprintf(request, "select %s %s %s", object, start, end);
	VPRINTF("%s\n", request);
	query(request);
	query("go");
	sprintf(request, "get %s", hostfile);
	VPRINTF("%s\n", request);
	query(request);
	query("go");

        fprintf(outfp, "                         MichNet Routers Management Report\n");
        fprintf(outfp, "\nFrom: %s", ctime(&s_unixtime));
        fprintf(outfp, "To:   %s\n", ctime(&e_unixtime));

        fprintf(outfp, "  Ethernet Interface             Up Percent\n");
        fprintf(outfp, " ------------------------------  ----------\n");

        print_ethernet(less, greater);

        fprintf(outfp, "\n                                 Total Down   # Failures  Max. Down     Uptime\n");
        fprintf(outfp, "         Node                      Minutes     Occurred    Minutes    Percentage\n");
        fprintf(outfp, " ------------------------------  -----------  ----------  ----------  ----------\n");

        print_report(less, greater);

	fclose(readfp);
	fclose(writefp);
}
