/************************************************************************
 *		getneighbors.c	- get MERIT and AS Neighbors		*
 *									*
 *	Added a -l option to be used to update the LINKS file		*
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include <time.h>

#include "snmptable2.h"

#define MAXLINKS 900

/* Add max retries =1 since snmp_next does own retries */
char *MERITVariables[]={
		"meritNT.0",
		};

char *progname;

struct MERITType {
	char LocalNode[40];			/* IPAddr of responding node */
	char LocalAddress[40];
	char RemoteNode[40];		/* MERIT-RemoteAddress in the index */
	char RemoteAddress[40];		/* MERIT-RemoteAddress in the index */
	int State;		/* 0 = UP, otherwise it is the Merit State */
} Links[MAXLINKS];
int NumLinks=0;


/************* Routines for MERIT and Extended Query information ***********/

/************************************************************************
 *	FindLink() - Given a NodeAddr and Remote IPAddr			*
 *			return index for the link or -1			*
 ************************************************************************/
int FindLink(LocalNode, RemoteNode)
     char *LocalNode;
     char *RemoteNode;
{
int i;
	for(i=0; i<NumLinks; i++)
		if ((strcmp(LocalNode,Links[i].LocalNode)==0) &&
			(strcmp(RemoteNode,Links[i].RemoteNode)==0))
			return(i);
	return(-1);
}

/************************************************************************
 * AllocLink() - given NodeAddr and RemoteAddr, allocate a Link Struct  *
 *			return index for Link struct			*
 ************************************************************************/
int AllocLink(LocalNode, RemoteAddress)
     char *LocalNode;
     char *RemoteAddress;
{

	if ( NumLinks == MAXLINKS-1 ) {
		fprintf(stderr,"Ran out of links: max = %d\n",MAXLINKS);
		return NumLinks;
	}
	strcpy( Links[NumLinks].RemoteNode, RemoteAddress );
	strcpy( Links[NumLinks].RemoteAddress, RemoteAddress );
	strcpy( Links[NumLinks].LocalNode,LocalNode );
	Links[NumLinks].LocalAddress[0]='\0';
	Links[NumLinks].State=0;
	return(NumLinks++);
}

/************************************************************************
 * Given Merit Neighbor State, come up with an UP / DOWN boolean	*
 *      x40     Dead Node path is open					*
 *      x20     This link is to an SCP					*
 *      x10     Indicates Status record MUST be sent			*
 *      x08     Status record has been received				*
 *      x04     Path has been opened					*
 *      x02     Dead node is attended					*
 *      x01     SAUCB is Q'd on PCB					*
 ************************************************************************/
int MeritNeighborState( state )
unsigned char state;
{
	if ((state & 0x44) == 0x04)
		return(0);
	else
		return((int)state);
}

/************************************************************************
 *									*
 ************************************************************************/
void AddMERITData(LocalNode, buffer )
     char *LocalNode;
     unsigned char *buffer;		/* NeighborTable */
{
int length, i;
unsigned char *p,NeighborName[5], LocalName[5];

	if (verbose) fprintf(stderr,"%s:\n%s\n",LocalNode,buffer);
        length = strlen(buffer);
	p=buffer;
	/*** 5 characters per node ***/
	if ( strlen(buffer) % 5  != 0 ) {
		fprintf(stderr,"Incomplete NeighborTable from %s...ignoring\n",LocalNode);
		return;
	}
	strncpy( LocalName, LocalNode , 5 );
	LocalName[4]='\0';
	strtok( LocalName, " .\n\r\t" );	/* break off name */

        for (i = 0; (p < (buffer + length - 1)); i++, p += 5) {
                strncpy( NeighborName, p, 4);
		NeighborName[4]='\0';
		/**************************/
		/** Handle special cases **/
		/**************************/
                if (strncmp(NeighborName, "**", 2) == 0) {
			i--;	/* Don't count this link! */
                        continue;
                }
#ifdef STRICT
		if ( strncmp(NeighborName,"E0",2)==0) continue;
		if ( strncmp(NeighborName,"E1",2)==0) continue;
		if ( strncmp(NeighborName,"E2",2)==0) continue;
		if ( strncmp(NeighborName,"E3",2)==0) continue;
		if ( strncmp(NeighborName,"E4",2)==0) continue;
#endif
		/*  if this PCP claims to have a Ethernet, we don't care
			but if that is all he has, and we don't mention any
			connetions, then the caller may
			see nothing from this node and assume he is busy.
			Solution: report E0-E4 as link to self   @wbn */
		if ( strncmp(NeighborName,"E0",2)==0) 
			strcpy( NeighborName, LocalName );
		if ( strncmp(NeighborName,"E1",2)==0) 
			strcpy( NeighborName, LocalName );
		if ( strncmp(NeighborName,"E2",2)==0)
			strcpy( NeighborName, LocalName );
		if ( strncmp(NeighborName,"E3",2)==0)
			strcpy( NeighborName, LocalName );
		if ( strncmp(NeighborName,"E4",2)==0)
			strcpy( NeighborName, LocalName );
		if ( (i=FindLink(LocalNode,NeighborName))==-1)
			i=AllocLink(LocalNode,NeighborName);
		strcpy(Links[i].LocalAddress,Links[i].LocalNode);
		strcpy(Links[i].RemoteAddress,Links[i].RemoteNode);
		Links[i].State=MeritNeighborState(*(p+4));
	}
}

/*************************************************************************
 * FormatMERITData() - Process each VarList and Binding adding it to the  *
 *			appropriate MERIT Data structure.		 *
 *************************************************************************/
void FormatMERITData( AddressListHead )
     struct AddressListType *AddressListHead;
{
struct VarList *v;
struct bindings *b;

        for( v=AddressListHead->ResponseListHead; v!=NULL; v=v->Next)
		for( b=v->Head; b!=NULL; b=b->Next )
	 		AddMERITData(AddressListHead->Address,b->value);
}

/************************************************************************
 * MERITReport() - Report information in the Links structure		*
 ************************************************************************/
void MERITReport()
{
int i;

        for(i=0; i<NumLinks; i++) {
		strtok( Links[i].LocalNode,".");
		strtok( Links[i].LocalAddress,".");
		strtok( Links[i].RemoteNode,".");
		strtok( Links[i].RemoteAddress,".");
		if ( Links[i].State == 0 )	/* Don't show DOWN links */
                printf("%s LINK INPLINK %s %s %s %s %s\n",
                                Links[i].LocalNode,
                                Links[i].LocalNode,
                                Links[i].LocalAddress,
                                Links[i].RemoteAddress,
                                Links[i].RemoteNode,
                                Links[i].State?"DOWN":"UP");
        }
}

/************************************************************************
 *	PrintReport() - Print a Formatted report of collected info	*
 *									*
 *	This consists of the Links array and the AS Chain		*
 ************************************************************************/
void PrintReport()
{
	MERITReport();
}

void Usage()
{
	fprintf(stderr,"Usage: %s [-v] [-d] [-i] [-a] [-l] -h <node> ... -h <node> -c <community>\n",progname);
	exit(1);
}

int main( argc, argv )
int argc;
char *argv[];
{
char *community=NULL,*name,*ipaddr;
struct VarList *QueryListHead=NULL;
struct AddressListType *AddressListHead=NULL,*A=NULL;
int i;
extern int MaxSecsB4Retry;
extern int MaxSNMPRetries;
char NodeName[100];

	progname=argv[0];
        argv++; argc--;
        while( *argv!=NULL && argv[0][0] == '-') {
                switch(argv[0][1]) {
                case 'd':
                case 'v':       
				fprintf(stderr,"Verbose Mode=ON\n");
				verbose=1;
                                argv++; argc--;
                                break;
                case 'h':
			for(i=0; i<strlen(argv[1]); i++ )
				if (islower(argv[1][i]))
					argv[1][i]=toupper(argv[1][i]);
			name=strtok(argv[1],": \t\n");
			sprintf(NodeName,"%s.merit.edu",name);
                        AddressListHead=AddAddress( AddressListHead, NodeName );
                        argv++; argc--;
                        argv++; argc--;
                        break;
                case 'c':
                        community=argv[1];
                        argv++; argc--;
                        argv++; argc--;
                        break;
                case 'r':
                        argv++; argc--;
                        if ( ( argc != 0 ) && ( atoi(argv[0]) != 0 )) {
                                MaxSNMPRetries=atoi(argv[0]);
                                argv++; argc--;
                        }
                        else fprintf(stderr,"Invalid retry specification\n");
                        break;
                case 't':
                        argv++; argc--;
                        if ( ( argc != 0 ) && ( atoi(argv[0]) != 0 )) {
                                 MaxSecsB4Retry=atoi(argv[0]);
                                argv++; argc--;
                        }
                        else fprintf(stderr,"Invalid retry specification\n");
                        break;
                default:
                        fprintf(stderr,"unknown option %s ignored\n(Valid options are: -v )\n",argv[0]);
                        argv++; argc--;
                        break;
                }
        }
	if ( community==NULL) {
		fprintf(stderr,"You MUST specify a community name \n");
		Usage();
	}

	for(i=0; i<((sizeof(MERITVariables))/(sizeof(char *))); i++)
       	QueryListHead=AddVar(QueryListHead,MERITVariables[i]);

	AddressListHead=Get( AddressListHead, community, QueryListHead );
	for( A=AddressListHead; A!=NULL; A=A->Next ) {
		if ( verbose ) printf("Processing responses from %s\n",A->Address);
		if (A->QueryListHead!=NULL) 
			fprintf(stderr,"%s did not respond completely to IS-IS Query\n",A->Address);
		else FormatMERITData( A );
#ifdef DEBUG
		printf("A->Address=%s\n",A->Address); fflush( stdout);
		if ( A->Next == NULL )
			printf("LASTONE\n");
		else 
			printf("A->Next=%s\n",A->Next->Address); fflush( stdout);
#endif
	}
	PrintReport();
	exit(0);
}

