/*
 * Copyright (c) 1989, 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 */

#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include <sys/param.h>
#ifndef FREEBSD
#include <malloc.h>
#endif
#include "netquery.h"

TestPORT(port, host)
char *port, *host;
{                                               
	struct sockaddr_in i;
	struct hostent *hp;
	int s,rc,portnum=0;
	register struct servent *sp;
	char buffer[100];
	
	if ( ( portnum=atoi( port ) ) == 0 )
		sp = getservbyname(port, "tcp"); /* TCP */

	i.sin_addr.s_addr = inet_addr(host);
	hp = gethostbyaddr((char *) &i.sin_addr.s_addr, 
					sizeof(struct in_addr), AF_INET);
	if (hp != NULL)
		host = hp->h_name;
	if (sp == NULL && portnum==0 ) {
		fprintf(stderr, " unknown service %s\n", port);
		return(ITBROKE);
	}
	i.sin_family = AF_INET;
	if ( portnum )
		i.sin_port = portnum;
	else
		i.sin_port = sp->s_port;
	

	/* try to connect */
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s < 0) {
		perror("socket");
		return(ITBROKE);
	}

	if ((rc=connect(s, (struct sockaddr *) &i, sizeof (i))) < 0) {
		close(s);
		switch(errno) {
			case ECONNREFUSED:
			case EADDRNOTAVAIL:
			case ETIMEDOUT:
				/*sprintf(buffer,"testport.c: connect failed for remote reasons: ");
				perror( buffer );*/
				return(ITBROKE);
				break;
			default:
				/*
					We have a situation where the
					connection request failed, but it
					doesn't appear to be caused by the
					remote machine.  Allow the local
					machine administor to see the error.
				*/
				sprintf(buffer,"testport.c: connect failed for local reason %d:",rc);
				perror(buffer); /* Print local error */
				return(ITWORKS);
				break;
		}
	}
	close(s);
	return(ITWORKS);
}

#ifdef STANDALONE
main( argc, argv )
int argc;
char *argv[];
{

	if ( argc != 3 ) {
		fprintf( stderr, "Usage %s host port\n", argv[0] );
		exit(1);
	}
	TestPORT( argv[2], argv[1] );
}
#endif
