/*--------------------connect/ns.c-----------------------------------*/

#define BIT_ZERO_ON_RIGHT 1
#define LOCAL_NAMESERVER_QUERY "nic.merit.edu"

#include <stdio.h>
#include <sys/types.h>
#include <arpa/nameser.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <resolv.h>
#include <netdb.h>
#include <memory.h>

char answer[PACKETSZ];
extern int h_errno;

int shh = 1;
#ifdef STANDALONE
main(argc, argv)
int argc;
char *argv[];
{
	extern void exit();

        if (argc < 2 || argc > 3) {
                fprintf(stderr, "Usage:  %s [-v] nameserver-address\n", argv[0])
;
                exit(5);
        }

        if (argc == 3)
                if (!(strcmp(argv[1], "-v"))) {
                        shh--;
                        argv[1] = argv[2];
                }
                else {
                        fprintf(stderr, "Usage:  %s [-v] nameserver-address\n",
argv[0]);
                        exit(5);
                }

	exit(NAMEDTest( argv[1] ));
	/*NOTREACHED*/
}
#endif

int NAMEDTest( addr )
char *addr;
{
	unsigned long ul;

	/*
	 *  To explicitly set the nameserver ourselves, we need to
	 *  first call res_init() - rather than relying upon res_query()
	 *  to do it for us below - and then copy in the value we want
	 *  for the nameserver before calling res_query().
	 */
	(void) res_init();
	
	/*
	 *  Yes, inet_addr() returns an unsigned long, but -1 on
	 *  an error . . .  What an interface . . .
	 */
        if ((ul = inet_addr(addr)) == (unsigned) -1L) {
                printf("[%s] is not a valid Internet address.\n", addr);
#ifdef STANDALONE
                exit(5);
#else
		return(1);
#endif
        }

	/* now reconfigure */
	_res.nscount = 1;
	_res.nsaddr.sin_addr.s_addr = ul;
        _res.nsaddr.sin_family = AF_INET;
	_res.nsaddr.sin_port = NAMESERVER_PORT;

        /* do the query */
        if (res_query(LOCAL_NAMESERVER_QUERY, C_IN, T_ANY, answer, PACKETSZ) < 0) {
                if (!shh)
                        printf("Nameserver at %s is having problems\n", addr)
;
#ifdef STANDALONE
                exit(7);
#else
		return(1);
#endif
        }
        else {
                if (!shh)
                        printf("Nameserver at %s is alive and well\n", addr);
#ifdef STANDALONE
                exit(0);
#else
		return(0);
#endif
        }
}
