/*
 * Copyright (c) 1989, 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 */

#include <curses.h>
#ifdef _AIX
#include <term.h>
#endif
#include <time.h>
#include <ctype.h>
#include <string.h>
#include <sys/file.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <pwd.h>
#include <sys/stat.h>
#include <malloc.h>

#include "CommonDefs.h"
#include "problem.h"
#include "pathnames.h"
#include "ctools.h"
#include "display.h"

extern struct Filters Filter[];
extern int FilterFuture;
extern int FutureAlarmsExist;
extern int CollectorDiedInterval;

struct Filters *AddFilter( Name, RegExp, Selected )
char *Name,*RegExp;
int Selected;
{
	static int virgin = 1, Tail = 0;
	int i;
	char *Pattern;
#ifdef _AIX
	char *regcmp();
#else
	char *re_comp();
#endif

	if ( virgin ) {
		for( i=0; i<MAXFILTERS; i++ ) Filter[i].Name=NULL;
		virgin=0;
	}
        if ( Tail+1 >= MAXFILTERS ) {
               	fprintf(stderr,"TOO MANY FILTERS (MAX=%d)\n",MAXFILTERS);
		return(NULL);
	}
	for(i=0; i<Tail; i++)
		if ( strcmp( Name, Filter[i].Name ) == 0 ) return(NULL); /* No Dups */
	i=Tail;
	/*
	 *	The AIX systems actually have a pattern returned that we can
	 *	compile once and reuse.  Other systems, we need to compile
	 * 	the pattern each time, and perform the compare.
	 */
#ifdef _AIX
        if ( ( Pattern = regcmp( RegExp, NULL ) ) == NULL ) {
#else
        if ( ( Pattern = re_comp( RegExp ) ) != NULL )  {
#endif
		return(NULL);
	}
#ifdef _AIX
        Filter[i].Pattern= malloc( (unsigned) (strlen(Pattern) + 1)); 
	strcpy( Filter[i].Pattern, Pattern);
#endif
        Filter[i].Name = malloc((unsigned) (strlen(Name) + 1)); 
	strcpy( Filter[i].Name, Name );
        Filter[i].RegExp = malloc((unsigned) (strlen(RegExp) + 1));
	strcpy( Filter[i].RegExp, RegExp );
        Filter[i].Selected=Selected;
        Filter[i].count=0;
	return( &Filter[Tail++] );
}

SetupFilters()
{
	FILE *stream;
	int line;
	char inbuffer[200];
	char *Name, *RegExp;
	extern char Filter_File[];
	extern void Message();

        if ( ( stream = fopen( Filter_File, "r" )) == NULL ) return;

        for(line=1; fgets( inbuffer, 100, stream ) != NULL; line++) {
                if (inbuffer[0] == '#' ) continue;
                if ((Name=strtok(inbuffer," \t\n"))==NULL) {
                        fprintf(stderr,"Blank Line  in filter file: %s line %d \n",Filter_File, line);
                        continue; /*BLANK*/
                }

                if ((RegExp=strtok((char *) NULL," \t\n"))==NULL) {
                        fprintf(stderr,"NULL Regular Expression in filterfile: %s line %d (%s)\n",Filter_File, line,Name );
                        continue;
                }
		if ( AddFilter( Name, RegExp, 1 ) == NULL ) 
			Message("Error compiling/Adding Filter");
        }
        fclose(stream);
}

char *ElapsedMins( diff )
long diff;		/* Elapsed Seconds */
{
	static char buffer[20];
	int 	ElapsedDay,ElapsedHr,ElapsedMin;

	if (ElapsedDay= diff / SECSDAY ) diff %= (ElapsedDay*SECSDAY);
	if (ElapsedHr = diff / SECSHR ) diff %= (ElapsedHr*SECSHR);
	ElapsedMin= diff / SECSMIN;
	if ( ElapsedDay ) sprintf( buffer,"%d:%2.2d:%2.2d",
				ElapsedDay,ElapsedHr,ElapsedMin );
	else
		if ( ElapsedHr ) sprintf( buffer,"%d:%2.2d",
				ElapsedHr,ElapsedMin );
		else
			if ( ElapsedMin ) sprintf( buffer,"%d",
						ElapsedMin );
			else sprintf(buffer,"%d",0);
	return( buffer );
}

char *PrintTimeStamp( TimeStamp )
long TimeStamp;
{
	static char buffer[50];
	long TimeNow;
	extern int TimeStampFormat;

	switch( TimeStampFormat ) {
	case LONGTIME:	return( ltoa( TimeStamp, buffer ) );
				/*NOTREACHED*/
	case HUMANTIME:	sprintf(buffer,"%s_%s ",
					_Day( TimeStamp ), _Time( TimeStamp ));
				return( buffer );
				/*NOTREACHED*/
	case ELAPSEDMIN:	time( & TimeNow );
				/*return( ltoa( (TimeNow-TimeStamp)/60, buffer) );*/
				return( ElapsedMins(TimeNow-TimeStamp) );
				/*NOTREACHED*/
	case ELAPSEDSEC:	time( & TimeNow );
				return( ltoa( (TimeNow-TimeStamp), buffer ) );
				/*NOTREACHED*/
	default:		return("BADCALL");
				/*NOTREACHED*/
	}
}
	

#ifndef OLD
/******************************************************************
 * ReadChecking:  See what node the background pingky is querying *
 ******************************************************************/
ReadChecking()
{
char *collectorname,buf[BUFSIZ],*p,filename[MAXPATHLEN];
extern char *pingkydir;
long timenow=time(&timenow);
struct stat st;
DIR *dp;
struct dirent *entry;

        if ((dp = opendir(pingkydir)) == NULL) {
                perror("opendir");
                return;
        }

        while ((entry = readdir(dp ) ) != NULL ) {
                if ((p = strrchr(entry->d_name, '.')) == NULL)
                        continue;
                if (strcmp(p, ".STATUS") == 0) {
                        sprintf(filename, "%s/%s", pingkydir, entry->d_name);
                        if ( stat( filename, &st ) != 0 ) {
                                fprintf(stderr,"ReadChecking(): stat of %s failed\n",filename);
                                continue;
                        }
                        if ( timenow - st.st_mtime > CollectorDiedInterval*60 ){
				collectorname=strtok(entry->d_name,".");
				mvaddstr(LINES-1,0,"A COLLECTOR has NOT BEEN RUNNING FOR AT LEAST 5 MINUTES!!");
				sprintf(buf,"** %s Collector Died %16.16s RIP",collectorname,ctime(&st.st_mtime));
				mvaddstr(1,10,buf);
				printf("");
			}
		}
	}
	closedir(dp);
}
#else
/******************************************************************
 * ReadChecking:  See what node the background pingky is querying *
 ******************************************************************/
ReadChecking()
{
char buffer2[100];
long timenow=time(&timenow);
struct stat mystat;
extern char inetrovercycletime[];
extern char pingdcycletime[];
extern char newrovercycletime[];

	if ( 	(stat(inetrovercycletime,&mystat)==0) && 
		((timenow - mystat.st_mtime ) > 60*CollectorDiedInterval  ) ) {
		mvaddstr(LINES-1,0,"InetRoverd COLLECTOR has NOT BEEN RUNNING FOR AT LEAST 5 MINUTES!!");
		sprintf(buffer2,"** InetRoverd Collector Died %16.16s RIP",ctime(&mystat.st_mtime));
		mvaddstr(1,10,buffer2);
		printf("");
	}
	if ( 	(stat(newrovercycletime,&mystat)==0) && 
		((timenow - mystat.st_mtime ) > 60*CollectorDiedInterval  )) {
		mvaddstr(LINES-1,0,"NewRover COLLECTOR has NOT BEEN RUNNING FOR AT LEAST 5 MINUTES!!");
		sprintf(buffer2,"** NewRover Collector Died %16.16s ",ctime(&mystat.st_mtime));
		mvaddstr(1,10,buffer2);
		printf("");
	}
	if ( 	(stat(pingdcycletime,&mystat)==0) && 
		((timenow - mystat.st_mtime ) > 60*CollectorDiedInterval  )) {
		mvaddstr(LINES-1,0,"pingd COLLECTOR has NOT BEEN RUNNING FOR AT LEAST 5 MINUTES!!");
		sprintf(buffer2,"** pingd Collector Died %16.16s ",ctime(&mystat.st_mtime));
		mvaddstr(1,10,buffer2);
		printf("");
	}
}
#endif

CountProblem( p )
struct ProblemType *p;
{
extern char *regex();
int i;

	if ( p == NULL ) {
		for( i=0; Filter[i].Name!=NULL; i++ ) 
			Filter[i].count=0;
		return;
	}
        for( i=0; Filter[i].Name!=NULL; i++ ) {
#ifndef _AIX
                re_comp( Filter[i].RegExp );
                if ( re_exec( p->Name ) == 1 ) 
#else
                if ( regex( Filter[i].Pattern, p->Name ) != NULL ) 
#endif
                        Filter[i].count++;
        }
}


/*
 *      Filter - Actual Filter Routine ( called for each problem entry
 */
int FilterProblem( p )
struct ProblemType *p;
{
time_t TimeNow=time(&TimeNow);
extern char *regex();
int i;

        for( i=0; Filter[i].Name!=NULL; i++ ) {
#ifndef _AIX
                re_comp( Filter[i].RegExp );
                if ( re_exec( p->Name ) == 1 ) {
#else
                if ( regex( Filter[i].Pattern, p->Name ) != NULL ) {
#endif
                        if ( Filter[i].Selected==FALSE) {
                                return(0);
                        }
                        /*else return(1); /* Matches pattern -user wants to see*/
                }
                else;   /* See if we match the next one */
        }
	if ((FilterFuture) && ( p->TimeStamp > TimeNow )) {
		FutureAlarmsExist=1;
		return(0);
	}
        return(1);      /* No Match - user wants to see */
}


/***********************************************************************
 * GetUpdateList: get the user's request to update a list of problems. *
 ***********************************************************************/
int GetUpdateList()
{
char problemID[100];

   getstr(problemID);		/* 	get the user's string 	*/
   return(atoi(problemID));
}


/**********************************************************************
 * DeleteProblem() - Allow User to delete a Problem From the Problem  *
 *								 File *
 **********************************************************************/
DeleteProblem()
{
	char *name, buffer[200], ProblemNumber[100];
	int Num;
	struct passwd *mypass;
	extern int NumProblems;
	extern char logfile[];
	extern void Message();
	extern struct ProblemType ProblemArray[];


	SetUpdating( 0 );
        Message("  Enter the Problem # of the Problem you want to Delete");
        move(LINES-2,26);
        refresh();
        getstr(ProblemNumber);
        refresh();
	if ((( Num = atoi(ProblemNumber) ) > NumProblems ) || (Num<1)) {
		Message(" That isn't a valid Problem Number ");
		sleep( 5 );
		ClearUpdating();
		return 0;
	} 
	 buffer[199]='\0';
/* NCS - pkn - we need to know who the problem was deleted by, if possible */
         if ((mypass = getpwuid((uid_t) getuid())) == NULL )
           name = "Unknown Person";
         else
           name = mypass->pw_name;

         sprintf(buffer,"%s %s %s %s Problem DELETED BY %s Old StatusLine: %s\n",
		_Day(ProblemArray[Num-1].TimeStamp),_Time(ProblemArray[Num-1].TimeStamp),
		ProblemArray[Num-1].Name,ProblemArray[Num-1].TestName,name,
		ProblemArray[Num-1].StatusLine);
         Log(buffer,logfile);
	Problem_Manager( DELETE_PROBLEM, ProblemArray[Num-1].TestName, ProblemArray[Num-1].Name, ProblemArray[Num-1].UniqueID, (char *) NULL );

        Message(" Done ");
	ClearUpdating();
	return 1;
}

GetFilter()
{
	extern void Message();
	char buffer[80],Name[40],fcount[4];
	int i;

	SetUpdating( 0 );
	strcpy(buffer,"Filters: ");
	for( i=0; i<MAXFILTERS && Filter[i].Name!=NULL && (strlen(buffer)+strlen(Filter[i].Name) < 80); i++) {
		if ( Filter[i].Selected ) strcat(buffer,"*");
		strcat(buffer,Filter[i].Name);
		strcat(buffer,"[");
		strcat( buffer, itoa( Filter[i].count, fcount ));
		strcat(buffer,"]");
		strcat(buffer," ");
	}
        Message(buffer);
        move(LINES-2,20);
        refresh();
        getstr(Name);
        refresh();
	for( i=0; i<MAXFILTERS && Filter[i].Name!=NULL; i++) {
		if ( strcmp( Name, Filter[i].Name ) == 0 ) {
			Filter[i].Selected^=1; 
			ClearUpdating();
			return;
		}
	}
	if ( Name[0] == '+' ) 
		if ( AddFilter( Name+1, Name+1, 0 ) != NULL )
			return;
	Message(" That isn't a valid Filter Name");
	sleep( 3 );
	ClearUpdating();
}

/************************************************************************
 *  ping : ping a particular node					*
 ************************************************************************/
Ping()
{
	extern void Message();
	char ProblemNumber[100],cmd[100],*addr;
	int Num=0;
	extern int NumProblems;
	extern struct ProblemType ProblemArray[];

        addstr("ing node in problem # ");
        Message("  Enter the Problem or the address # of the node you want to ping");
        move(LINES-2,35);
        refresh();
        getstr(ProblemNumber);
        refresh();
	if ( strchr( ProblemNumber, '.' ) != NULL )
		addr=ProblemNumber;	
	else
	if ((( Num = atoi(ProblemNumber) ) > NumProblems ) || (Num<1)) {
		Message(" That isn't a valid Problem Number ");
		sleep( 5 );
		return 0;
	} else addr=ProblemArray[Num-1].UniqueID; 
#ifdef _AIX
	sprintf( cmd, "ping %s",addr);
#else
	sprintf( cmd, "ping -s %s",addr);
#endif
		system( cmd );
			printf("Strike a key when ready..."); fflush(stdout);	
			getch();
	return(0);
}
/************************************************************************
 *  traceroute:	traceroute to a particular node				*
 ************************************************************************/
TraceRoute()
{
	extern void Message();
	char ProblemNumber[100],cmd[100],*addr;
	int Num=0;
	extern int NumProblems;
	extern struct ProblemType ProblemArray[];

        addstr("raceroute to node in problem # ");
        Message("  Enter the Problem # or the address of the node you want to Traceroute ");
        move(LINES-2,40);
        refresh();
        getstr(ProblemNumber);
        refresh();
	if ( strchr( ProblemNumber, '.' ) != NULL )
		addr=ProblemNumber;	
	else
	if ((( Num = atoi(ProblemNumber) ) > NumProblems ) || (Num<1)) {
		Message(" That isn't a valid Problem Number ");
		sleep( 5 );
		return 0;
	} else addr=ProblemArray[Num-1].UniqueID; 
	sprintf( cmd, "traceroute %s",addr );
		system( cmd );
			printf("Strike a key when ready..."); fflush(stdout);	
			getch();
	return(0);
}

/************************************************************************
 *  GetHelp:	Display Help screen for a particular problem node	*
 ************************************************************************/
GetHelp()
{
	extern void Message();
	char ProblemNumber[100];
	int Num;
	extern int NumProblems;
	extern struct ProblemType ProblemArray[];

        addstr("elp with problem # ");
        Message("  Enter the Problem # of the Problem you want help with");
        move(LINES-2,30);
        refresh();
        getstr(ProblemNumber);
        refresh();
	if ((( Num = atoi(ProblemNumber) ) > NumProblems ) || (Num<1)) {
		Message(" That isn't a valid Problem Number ");
		sleep( 5 );
		return 0;
	} 
	Help( ProblemArray[Num-1].UniqueID);
	return(0);
}

more( NodeName,filename )
char *NodeName;
char *filename;
{
	FILE *stream;
	char buffer[200];
	int i=0;
	char ch;
	extern void Message();

	if ((stream=fopen(filename,"r"))==NULL) {
		sprintf(buffer,"Can't open %s - no help available\n",filename);
		Message( buffer );
		return;
	}
	while( fgets( buffer, sizeof(buffer), stream ) != NULL ) {
		printf(buffer);
		if ( ++i >= LINES-1 ) {
			printf( "-- %s File : %s    Strike a key when ready... --",NodeName,filename);
			fflush(stdout);
			ch=getch();
			if ((ch=='Q')||(ch=='q')) break;
			printf("\n");
			i=0;
		}
	}
	fclose(stream);
}

Help( UniqueID )
char *UniqueID;
{
	FILE *stream;
	char buffer[200], *file, *p;
	int line=1;
	extern int Updating;
	extern char hostfile[100];
	extern void Message();
	extern char *pingkydir;
	char filename[ BUFSIZ ];

	if ((stream=fopen(hostfile,"r"))==NULL) {
		sprintf(buffer,"No hostfile (%s) available - No Help available",
			hostfile );
		Message(buffer);
		sleep(5);
		return;
	}
	while( ( p=fgets( buffer, sizeof(buffer), stream )) != NULL ) {
		if (( p=strtok( buffer," \t\n")) == NULL ) continue; /*NodeName*/
		if ( *p == '#' ) continue;
		if (( p=strtok( NULL," \t\n")) == NULL ) continue; /*UniqueID*/
		if ( strcmp( UniqueID, p ) == 0 ) {
			Updating=1;	/* Don't redraw the screen */
			/*if (strtok((char *) NULL, " \t\n" ) == NULL)
				break;*/
			if ((file = strtok((char *) NULL, " \t\n")) == NULL) 
				break;
			clear();
			refresh();
			strcpy( filename, pingkydir );
			strcat( filename, "/" );
			strcat( filename, file );
			more(UniqueID,filename);
			printf("Strike a key when ready..."); fflush(stdout);	
			getch();
			Updating = 0;
			fclose(stream);
			return;
		}
		line++;
	}
	fclose(stream);
	if ( p == NULL ) {
		sprintf(buffer," No Help available for Node %s",UniqueID);
		Message(buffer);
		sleep(5);
	}
	else 
		sprintf(buffer,
		    " Error in line #%d of hostfile - no help available",line);
	Message( buffer );
}

GetTroubleTicket()
{
	char buffer[200],TroubleTicketNumber[100];
	char tmpfile[100];
	extern int NumProblems;
	extern struct ProblemType ProblemArray[];
	extern void Message();

        SetUpdating( 0 );
        Message("  Enter the Trouble Ticket Number ");
        move(LINES-2,26);
        refresh();
        getstr(TroubleTicketNumber);
        refresh();
	if ( atoi(TroubleTicketNumber) ) {
		sprintf( tmpfile, "/tmp/tmp%s",TroubleTicketNumber);
		sprintf( buffer, "rtt %s >%s",TroubleTicketNumber,tmpfile);
		system(buffer);
		more( TroubleTicketNumber, tmpfile );
		unlink( tmpfile );
	}
        Message(" Done ");
        ClearUpdating();
        return 1;
}

SetUpdateable( file )
char *file;
{
extern char Updateable;	/* Don't Allow updating by default */

	if ( access( file, W_OK | F_OK ) == 0 ) Updateable=1;
	else Updateable=0;
}
