
/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#include <string.h>
#include <ctype.h>
#include "CommonDefs.h"
#include "ctools.h"
#include "StatusFileio.h"

static int CanQNodes[] = {	FALSE,          /* NOT USED */
				TRUE,           /* NSS */
				TRUE,           /* PCP  */
				FALSE,          /* SCP  */
				FALSE,          /* NETWORK */
				FALSE,          /* AS   */
				FALSE,          /* EGP PEER */
				TRUE,		/* GEN NODE */
				FALSE
};

static char *LineTypes[] = {	"NOT USED", 
				"NODE", 
				"LINK" 
};

static char *StateTypes[] = {	"NOT USED", 
				"NR", 
				"DOWN", 
				"BUSY", 
				"UP", 
				"MOVED" 
};

static char *NetworkTypes[] = {	"NOT USED", 
				"MERIT", 
				"NSFNET", 
				"NSFNETT3", 
				"NSFNETT3R",
				"GENERICNET" 
};

static char *NodeTypes[] = {	"NOT USED", 
				"NSS", 
				"PCP", 
				"SCP", 
				"NETWORK", 
				"AS", 
				"EGPPEER" ,
				"GENNODE"
};

static char *LinkTypes[] = {	"NOT USED", 
				"INPLINK", 
				"ISISLINK", 
				"EGPLINK", 
				"ASLINK", 
				"GENLINK" 
};

/************************************************************************
 *  InitNetwork - Initialize Network to NULL pointers ( No Nodes/Links) *
 ************************************************************************/
void InitNetwork(Net, Type, ConfigFile)
struct NetworkType *Net;
char *ConfigFile;
int Type;
{
        Net->Type = Type;
        Net->NodeHead = NULL;
        Net->NodeTail = NULL;
        Net->LinkHead = NULL;
        Net->LinkTail = NULL;
        strcpy(Net->ConfigFile, ConfigFile);
	return;
}

/************************************************************************
 * Str_To_NodeType() - String --->NodeType				*
 ************************************************************************/
Str_To_NodeType(str)
char *str;
{
	register char *s;
	register int i;

	for (s = str; *s != '\0'; s++)
		/*if (islower(*s))*/
		if (*s>='a' && *s<='z')
			*s = toupper(*s);
	for (i = 1; i <= LASTNODETYPE; i++)
		if (strcmp(str, NodeTypes[i]) == 0) 
			return(i);
        return(0);
}

/************************************************************************
 * CanQuery() - Returns TRUE/FALSE if this node type can be queried	*
 ************************************************************************/
CanQuery(Type)
int Type;
{
        if ((Type < 1) || (Type > LASTNODETYPE)) 
		return(FALSE);
	return (CanQNodes[Type]);
}

/************************************************************************
 * PrintNodeType() - NodeType--->String					*
 ************************************************************************/
char *PrintNodeType( Type )
int Type;
{
	static char buffer[100];
	extern char *itoa();

        if ((Type < 1) || (Type > LASTNODETYPE)) 
		return(itoa(Type, buffer));
        return(NodeTypes[Type]);
}

/************************************************************************
 * PrintNetworkType() - NetworkType--->String				*
 ************************************************************************/
char *PrintNetworkType(Type)
int Type;
{
	if ((Type < 1) || (Type > LASTNETWORKTYPE)) 
		return(NetworkTypes[GENERICNET]);
	return(NetworkTypes[Type]);
}

/************************************************************************
 * Str_To_NetworkType() - String ---->NetworkType			*
 ************************************************************************/
Str_To_NetworkType(str)
char *str;
{
	register char *s;
	char buffer[100];
	register int i;

	strcpy( buffer, str );

	for (s = buffer; *s != '\0'; s++)
		if (islower(*s))
			*s = toupper(*s);
	for (i = 1; i <= LASTNETWORKTYPE; i++)
		if (strcmp(buffer, NetworkTypes[i]) == 0) 
			return(i);
	return(GENERICNET);
}

/************************************************************************
 * PrintState() - State---->String					*
 ************************************************************************/
char *PrintState( State )
int State;
{
	static char buffer[100];
	extern char *itoa();

	if ((State < 1) || (State > LASTSTATETYPE)) 
		return(itoa(State,buffer));
	return(StateTypes[State]);
}

/************************************************************************
 * PrintLinkType() - LinkType---->String				*
 ************************************************************************/
char *PrintLinkType( Type )
int Type;
{
	static char buffer[100];
	extern char *itoa();

	if ((Type < 1) || (Type > LASTLINKTYPE)) 
		return(itoa(Type, buffer));
	return( LinkTypes[Type] );
}

/************************************************************************
 * Str_To_LinkType( ) - LinkType ------> String				*
 ************************************************************************/
Str_To_LinkType(str)
char *str;
{
	register char *s;
	register int i;

	for (s = str; *s != '\0'; s++)
		if (islower(*s))
			*s = toupper(*s);
	for (i = 1; i <= LASTLINKTYPE; i++)
		if (strcmp(str, LinkTypes[i]) == 0) 
			return(i);
	return(0);
}

/************************************************************************
 * Str_To_State( ) - State ------> String				*
 ************************************************************************/
Str_To_State( str )
char *str;
{
	register char *s;
	register int i;

	for (s = str; *s != '\0'; s++)
		if (islower(*s))
			*s = toupper(*s);
	for (i = 1; i <= LASTSTATETYPE; i++)
		if (strcmp(str, StateTypes[i]) == 0) 
			return(i);
	return(0);
}

/************************************************************************
 * Str_To_NodeState( ) - NodeState ------> String			*
 ************************************************************************/
Str_To_NodeState( str )
char *str;
{
	return(Str_To_State(str));
}

/************************************************************************
 * Str_To_LinkState( ) - LinkState ------> String			*
 ************************************************************************/
Str_To_LinkState( str )
char *str;
{
	int LinkState = Str_To_State(str);

	switch (LinkState) {	/* ONLY ALLOWABLE VALUES OF LINKS */
		case NR:
		case DOWN:
		case UP:
		case MOVED:
			return(LinkState);
			/*NOTREACHED*/
		default: 
			return(0);
			/*NOTREACHED*/
	}
}

/************************************************************************
 * Str_To_LineType( ) - String---------->LineType			*
 ************************************************************************/
Str_To_LineType(str)
char *str;
{
	register char *s;
	register int i;

	for (s = str; *s != '\0'; s++)
		if (islower(*s))
			*s = toupper(*s);
	for (i = 1; i <= LASTLINETYPE; i++)
		if (strcmp(str, LineTypes[i]) == 0) 
			return(i);
	return(0);
}

/************************************************************************
 * PrintLineType( ) - LineType------> String				*
 ************************************************************************/
char *PrintLineType(Type)
int Type;
{
	static char buffer[100];
	extern char *itoa();

	if ((Type < 1) || (Type > LASTLINETYPE)) 
		return(itoa(Type,buffer));
	return(LineTypes[Type]);
}
