/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

/************************************************************************
 *	getline.c - return next or previous log file line		*
 *									*
 *   Tape Player Code - This code deals with the playback mechanism 	*
 *			in the graphical display.			*
 *									*
 ************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "xmap.h"


static char *LogFileBuffer=NULL;
static char *LPtr=NULL;

/************************************************************************
 *	ReadLogFile() - Read the Log file into memory for operations	*
 ************************************************************************/
int ReadLogFile( filename, Direction )
char *filename;
int Direction;
{

struct stat stbuf;
int fd;

	if ( stat( filename, &stbuf ) == -1 ) {
		fprintf(stderr,"ReadLogFile(): File %s Not found\n", filename );
		return(1);
	}

	if ( LogFileBuffer != NULL ) 
		if (free( LogFileBuffer ) != 1 ) syserr("free: ");


	LogFileBuffer=(char *) malloc( stbuf.st_size +10 );

	if ( Direction == BACKWARD ) LPtr=LogFileBuffer+stbuf.st_size;
	else LPtr=LogFileBuffer;

	if ( ( fd = open( filename, O_RDONLY) ) == -1 ) {
		fprintf(stderr,"ReadLogFile(): File %s Not found\n", filename );
		return(1);
	}
	if ( ( read( fd, LogFileBuffer,  stbuf.st_size ) ) < 0 ) { 
		fprintf(stderr,"ReadLogFile(): %s:Error during Read\n", filename );
		close( fd );
		return(1);
	}
	close( fd );
	return(0);
}

/************************************************************************
 *	getline - read forward or backward 1 line and return the line 	*
 *		return( NULL ) at BOF or EOF				*
 *	The file pointer is assumed to ALWAYS be on the first char 	*
 *	of the line.							*
 *	( When at EOF, the pointer is on the \0				*
 ************************************************************************/
char *getline( direction)
int direction;
{
	extern void exit();
	static char buffer[BUFSIZ];
	int gotone = 0, mychar;
	char *p;

	switch (direction) {
	case FORWARD:
		for( p=LPtr; *p!='\0' && *p!='\n'; p++);
		if ( p == LPtr ) return( NULL );
		strncpy( buffer, LPtr, p-LPtr );
		buffer[ p-LPtr ] = '\0';
		LPtr=p+1;	/* go over \n to first char in next line */
		break;	/* buffer has this line now */

	case BACKWARD:
		if ( LPtr-2 <= LogFileBuffer ) return( NULL );

		for( p=LPtr-2; p>=LogFileBuffer; p-- ) /* backup til \n */
			if (*p=='\n') break;
		strncpy( buffer, p+1, LPtr-p );
		buffer[ LPtr-p ] = '\0';
		LPtr=p+1;
		break;
	default:
		fprintf( stderr,"Internal error - unknown getline direction\n");
		exit(1);
		/*NOTREACHED*/
	}
	/*printf("getline(%s) returning %s",(direction==FORWARD)?"FORWARD":"BACKWARD",buffer);*/
	return( buffer );
}

