/************************************************************************
 *		getneighbors.c	- get ISIS and ASys Neighbors		*
 *									*
 *	Added a -l option to be used to update the LINKS file		*
 ************************************************************************/

#include <stdio.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include <time.h>

#include "CommonDefs.h"
#include "snmptable2.h"
#include "Linkfileio.h"

/* Add max retries =1 since snmp_next does own retries */

char *LinkTableVariables[]={
		"is-isLocalAddr",
		"is-isIndex",
		};
int LinkTableFunction=0;

char *progname;

void Usage()
{
	fprintf(stderr,"Usage: %s [-v] [-d] [-i] [-a] [-l] -h <node> ... -h <node> -c <community>\n",progname);
	exit(1);
}

/************************************************************************
 * QAddress() - Convert 140.222 and 140.223. addresses to .62 addresses *
 ************************************************************************/
char *QAddress(address)
     char *address;
{
int octet1,octet2,octet3,octet4;
static char NodeName[100];

        if ((sscanf( address,"%d.%d.%d.%d",
                &octet1,&octet2,&octet3,&octet4))==4) {
                strcpy(NodeName,"");
                if ((octet1==140)&&((octet2==222)||(octet2==223)))
                        sprintf(NodeName,"%d.%d.%d.62",
                                octet1,octet2,octet3);
                else
                        if ((octet1==129)&&(octet2==140))
                                      sprintf(NodeName,"%d.%d.%d.1",
                                              octet1,octet2,octet3-64);
                        else strcpy(NodeName,address);
        }
        else strcpy(NodeName,address);
        return(NodeName);
}


#define LOCAL 1
#define REMOTE 2
/************************************************************************
 * AddLinkTableData() - Add LinkTable Data to appropriate Link Structure
  *
 *                                                                      *
 ************************************************************************/
void AddLinkTableData(RespondingAddress, VarName, RemoteAddress, value)
     char *RespondingAddress;
     char *VarName;
     char *RemoteAddress;
     char *value;           /* Value of Variable    */
{
int i,j, ThisSide;
struct LinkDetail *LPtr;
time_t TimeNow=time(&TimeNow);

	if ( strcmp( RespondingAddress,QAddress(RemoteAddress)) == 0 ) return;
        if ( (LPtr=FindPtPtLink(RespondingAddress,RemoteAddress))==NULL) {
                AddLinkDetail(
			0,		/* Unknown Type */
			TimeNow,	
			RespondingAddress,	/* Name */
			"Unknown",	/* Interface for now */
			0, 			/* if index */
			TimeNow, 
			QAddress(RemoteAddress), /* RemoteNode */
			RemoteAddress, 		/* Remote Address */
			0, 			/* Remote if # */
			0, 0 );			/* TT Info */
        	if ( (LPtr=FindPtPtLink(RespondingAddress,RemoteAddress))==NULL) {
			fprintf( stderr,"Internal error in AddLinkTableData(%s-%s)\n",RespondingAddress,RemoteAddress);
			return;
		}
	}
	if ( strcmp(LPtr->LocalNode,RespondingAddress) == 0 ) {
		ThisSide=LOCAL;
	}
	else 
		if ( strcmp(LPtr->RemoteNode,RespondingAddress) == 0 ) {
			ThisSide=REMOTE;
		}
		else {
			fprintf(stderr,"Error: This responding node %s corresponds neither to local %s or remote %s node\n",RespondingAddress,LPtr->LocalNode,LPtr->RemoteNode);
			return;
		}

        for(j=0; j<((sizeof(LinkTableVariables))/(sizeof(char *))); j++) {
                if (strcmp(LinkTableVariables[j],VarName)==0) {
                        switch( j ) {
                        case 0: /* LocalAddr */
				if ( ThisSide == LOCAL ) {
					strcpy( LPtr->LocalIPAddr, value );
                                	strcpy( LPtr->RemoteIPAddr,RemoteAddress);
				}
				else {
					strcpy( LPtr->RemoteIPAddr, value );
                                	strcpy( LPtr->LocalIPAddr,RemoteAddress);
				}
                                return;
                                /*NOTREACHED*/
                        case 1: /* DSU Index */
				if ( ThisSide == LOCAL ) {
					LPtr->LocalDSUNumber=atoi(value);
                                	strcpy( LPtr->RemoteIPAddr,RemoteAddress);
				} else {
					LPtr->RemoteDSUNumber=atoi(value);
                                	strcpy( LPtr->LocalIPAddr,RemoteAddress);
				}
                                return;
                                /*NOTREACHED*/
                        default:
                                fprintf(stderr,"Unrecognized Data Type %s\n",
                                                                VarName);
                                return;
                                /*NOTREACHED*/
                        }
                }
        }
}

/*************************************************************************
 * FormatLinkTableData() - Process each VarList and Binding adding it to the  *
 *                      appropriate LinkTable Data structure.                 *
 *************************************************************************/
void FormatLinkTableData(AddressListHead)
     struct AddressListType *AddressListHead;
{
struct AddressListType *A;
struct VarList *v;
struct bindings *b;

   for( A=AddressListHead; A!=NULL; A=A->Next )
        for( v=A->ResponseListHead; v!=NULL; v=v->Next)
                for( b=v->Head; b!=NULL; b=b->Next )
                         AddLinkTableData(A->Address,v->VarName,b->instance+strlen(v->Prefix),b->value);
}

/*************************************************************************
 * ProcessLinkType() - 
 *                   
 *************************************************************************/
void ProcessLinkType(AddressListHead)
     struct AddressListType *AddressListHead;
{
struct AddressListType *A;
struct VarList *v;
struct bindings *b;
struct LinkDetail *LPtr;
int LinkType;

   for( A=AddressListHead; A!=NULL; A=A->Next )
        for( v=A->ResponseListHead; v!=NULL; v=v->Next)
                for( b=v->Head; b!=NULL; b=b->Next ) {
			LinkType=atoi(b->value);
			if (( LinkType != 22 ) && (LinkType!=18)) continue;
			if ((LPtr=FindLinkDetail( A->Address, atoi(b->instance+strlen(v->Prefix))))!=NULL)
				LPtr->LinkType=atoi(b->value);
			else 
				if (verbose) fprintf(stderr,"Can't find %s:%d LinkType %d in NeighborTable\n",A->Address, atoi(b->instance+strlen(v->Prefix)),atoi(b->value));
		}

}


int main( argc, argv )
int argc;
char *argv[];
{
char *community=NULL;
struct VarList *QueryListHead=NULL;
struct AddressListType *AddressListHead=NULL,*A=NULL;
int i;
extern int MaxSecsB4Retry;
extern int MaxSNMPRetries;
char *network="nsfnett3";

	progname=argv[0];
        argv++; argc--;
        while( *argv!=NULL && argv[0][0] == '-') {
                switch(argv[0][1]) {
                case 'd':
                case 'v':       
				fprintf(stderr,"Verbose Mode=ON\n");
				verbose=1;
                                argv++; argc--;
                                break;
                case 'h':
                        AddressListHead=AddAddress( AddressListHead, argv[1] );
                        argv++; argc--;
                        argv++; argc--;
                        break;
                case 'c':
                        community=argv[1];
                        argv++; argc--;
                        argv++; argc--;
                        break;
                case 'r':
                        argv++; argc--;
                        if ( ( argc != 0 ) && ( atoi(argv[0]) != 0 )) {
                                MaxSNMPRetries=atoi(argv[0]);
                                argv++; argc--;
                        }
                        else fprintf(stderr,"Invalid retry specification\n");
                        break;
                case 't':
                        argv++; argc--;
                        if ( ( argc != 0 ) && ( atoi(argv[0]) != 0 )) {
                                 MaxSecsB4Retry=atoi(argv[0]);
                                argv++; argc--;
                        }
                        else fprintf(stderr,"Invalid retry specification\n");
                        break;
		case 'n':
                        argv++; argc--;
                        if ( argc != 0 )  {
                                 network=argv[0];
                                argv++; argc--;
                        }
                        else fprintf(stderr,"Invalid retry specification\n");
                        break;
                default:
                        fprintf(stderr,"unknown option %s ignored\n(Valid options are: -v -h addr [-h addr] -c community -r retrycount -t timeout )\n",argv[0]);
                        argv++; argc--;
                        break;
                }
        }
	if ( community==NULL) {
		fprintf(stderr,"You MUST specify a community name \n");
		Usage();
	}
	if ( AddressListHead==NULL) {
		fprintf(stderr,"You MUST specify at least one host\n");
		Usage();
	}

	Read_LinkDetail_File( network );	/* Read the Link DB */
	for(i=0; i<((sizeof(LinkTableVariables))/(sizeof(char *))); i++)
	      	QueryListHead=AddVar(QueryListHead,LinkTableVariables[i]);

	AddressListHead=GetTable( AddressListHead, community, QueryListHead );
	for( A=AddressListHead; A!=NULL; A=A->Next ) {
		if (A->QueryListHead!=NULL) 
			fprintf(stderr,"%s did not respond completely to LinkTable Query\n",A->Address);
		else FormatLinkTableData( A );
	}
	/*Update_LinkDetail_Table( );	/* Update Link Info */

	if (verbose) printf("Querying for iftype\n");
               FreeAddressListsVarList( AddressListHead );
               QueryListHead=NULL;
	QueryListHead=AddVar(QueryListHead,"ifType");
	AddressListHead=GetTable( AddressListHead, community, QueryListHead );
	for( A=AddressListHead; A!=NULL; A=A->Next ) {
		if (A->QueryListHead!=NULL) 
			fprintf(stderr,"%s did not respond completely to LinkTable ifType Query\n",A->Address);
		else ProcessLinkType( A );
	}
	Write_LinkDetail_File( );	/* Write DB back to disk */

	if (verbose) PrintLinkDetail();
	return(0);
}

