/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * Linkfileio.h - Include file for I/O with the LINKS file, along
 *		  with routines to manipulate the structures.
 */

#define MAXPOP       40
#define MAXCIRCUIT   40

#define REMOTEDSU	1
#define LOCALDSU	2

#define SECSPERMIN	60
#define MINSPERHR	60
#define HRSPERDAY	24

#define FOUR_DAYS	(4 * HRSPERDAY * MINSPERHR * SECSPERMIN)

#define UNKNOWN  0
#define T1 	18	/* Taken from ifType MIB Defs */
#define T3	22

struct LinkDetail { 				/* Linked List of LINK Info */
	int Valid;				/* is entry valid? 	    */
        int Dirty;                              /* Problem with this link?  */
        int LinkType;                           /* Link Type - Speed     ?  */
	time_t LocalTimeStamp;			/* TimeStamp the isisData   */
        char LocalPOP[ MAXPOP ];                /* MCI POP Name             */
        char LocalNode[ MAXIPADDRESS ];         /* IPAddress of NODE        */
        char LocalIPAddr[ MAXIPADDRESS ];       /* IPAddress of Interface   */
        int  LocalDSUNumber;                    /* Locally attached DSU     */
	int  LocalDSUSerialNumberVerified;
	char LocalDSUSerialNumber[40];		/* Local DSU Serial Number  */
        char Circuit[ MAXCIRCUIT ];             /* MCI Circuit Idenitfier   */
	char RemoteDSUSerialNumber[40];		/* Remote DSU Serial Number */
	int  RemoteDSUSerialNumberVerified;
        int  RemoteDSUNumber;                   /* Remote DSU Number        */
        char RemoteIPAddr[ MAXIPADDRESS ];      /* Remote Node IPAddress    */
        char RemoteNode[ MAXIPADDRESS ];        /* Remote IPAddr of Interface */
	time_t RemoteTimeStamp;			/* TimeStamp the isisData   */
        char RemotePOP[ MAXPOP ];               /* Remote MCI POP Name      */

	time_t TTLastOpened;		/* When the Last TT Reported */
	time_t TTNextAction;		/* Next Action and Dirty Bool*/
        struct LinkDetail *Next;
};

extern struct LinkDetail *LinkDetailHead;

void Write_LinkDetail_File(), Update_LinkDetail_File();
struct LinkDetail *AddLinkDetail(), *FindPtPtLink(), *Read_LinkDetail_File(), *FindLinkDetail();
