/*          CTOOLS.H  -  "C" Toolkit       */


char 	*right(),	/* right(string,n) - return right n chars of string */
	*left(),	/* left(string,n) - return left n chars of string */
	*mid(),		/* mid(string,start,n) - return mid n chars at start */
	*replicate(),	/* replicate(chr,n) - replicate n chars into ct_buff */
	*rjustify(),	/* rjustify(s,n) - right justify n chars into ct_buff*/
	*month_str();	/* month_str(date) - Char * Expanded out */

int	num_days(),	/* num_days(int month,int year) - # days in  */
	mday(),		/* mday(char *date) - Day # */
	year(),		/* year(char *date) - year from date */
	month(),	/* month(char *date) - month from date */
	wday();		/* wday(char *date) - */

char	*wday_str();	/* wday_str(char *date) - weekday */

long	calc_bd();	/* calc_bd(sdate,edate) returns # days between dates */
int	days_year();	/* days_year(year) return # days in the year */
char	*fd_forward(),	/* fd_forward(date,days) - char * to datestr in future*/
	*fd_backward(), /* fd_backward(date,days)-char * to datestr in past */
	*itoa(),	/* itoa(int n,char *s) - int n -> string s */
	*ltoa();	/* ltoa(long n,char *s) - long n -> string s */
int	reverse(),	/* reverse(s) - reverse string */
	instr(),	/* instr(string,substring) - TRUE/FLASE */
	chg_chr(),	/* chg_chr(s,old,new) - change old char to new in s */
	num_suffix(),	/* num_suffix(char *str) - append st, nd,rd,th, etc */
	ltrim(),	/* ltrim(str) trim ' ' off front of string */
	rtrim(),	/* rtrim(str) trim ' ' off back of string */
	upper(),	/* upper(str) make string all upper case */
	word_end(),	/* word_end(char chr) return TRUE if end of wordchars*/
	hours_between(), /* hours_between(char *start, *end ) */
	mins_between();	/* mins_between(start,end) */

void Log();	/* Log(line,logfile) Append a timestamped log record to file*/
char *GetTime();/* Place a "Mon Mar 23 13:23\0" time string here */
int FileChanged(); /* FileChanged(filename,lastmodtime)		 */
void Empty_File();/* 		Empty this file 		 */
long LastMod();  /* LastMod( filename ) - returns Mod Time	 */
void panic();	/* panic - drastic event - toss string and die   */
void syserr(); 	/* print system call error message and terminate */
void fatal(); 	/* fatal(str)print error message and terminate 	 */
char lock();    /* lock(char *name) Acquire lock 		 */
void unlock(); 	/* unlock(char *name) free lock 		 */
char *lockpath(); /* lockpath(char *name) - make lock filename   */
void LogChecking(); /* LogChecking(str,filename) empty/append    */

char *_Day(), *_Time(); /* Return Mon and 04:34 respectively 	*/
