/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       trp.c
**     SYSTEM   NAME:       SNMP Trap Module 
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1990/11/22
**
** DESCRIPTION: SNMP Trap Module
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header$";
#endif
#include <sys/ioctl.h>
#include "err.h"            
#include "snmp.h"
#include "pkt.h"

trp_sck
    TrpSck =
{
    0,
    IPS_ERR
};

/**************************************************************
** NAME:        TrpOpn                                    [API]
** SYNOPSIS:    int
**                  TrpOpn
**                  (
**                      short       Prt,
**                  )
** DESCRIPTION: Opens a trap station.
**              Parameters:
**              Prt: IP Port.
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
int
    TrpOpn
    (
        short       Prt
    )
{
    IPS_IPA
        Sin;
    
    Sin.sin_family = AF_INET;
    Sin.sin_port = htons (Prt);
    Sin.sin_addr.s_addr = INADDR_ANY;
    if ((TrpSck.SckBsd = socket (AF_INET, SOCK_DGRAM, 0)) == IPS_ERR)
    {
        ERR_ERR (ERR_TRP, ERR_CRITICAL, "No socket\n");
        return (-1);
    }
    if (bind (TrpSck.SckBsd, (IPS_ADR *)&Sin, sizeof (IPS_IPA)) < 0)
    {
        ERR_ERR (ERR_TRP, ERR_CRITICAL, "Cannot bind socket\n");
        return (-1);
    }
    TrpSck.SckOpn = 1;
    return (0);
}

/**************************************************************
** NAME:        TrpPol                                    [API]
** SYNOPSIS:    int
**                  TrpPol
**                  (
**                      pkt_trp     *Trp
**                  )
** DESCRIPTION: Pols for a trap.
**              Parameters:
**              Trp: Trap packet.
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
int
    TrpPol
    (
        pkt_trp     *Trp
    )
{
    pkt_msg
        *Msg;
    pkt_trp
        *Pdu;
    char
        *Pkt;
    int
        PktLen,
        AdrLen;
    long
        Len;
    IPS_IPA
        Sin;

    Msg = &TrpSck.SckMsg;
    Pdu = &Msg->MsgPdu.PduTrp;
    if (!TrpSck.SckOpn)
        return (-1);
    ioctl (TrpSck.SckBsd, FIONREAD, (char *)&Len);
    if ((int) Len <= 0)
        return (-1);
	Pkt = TrpSck.SckPkt;
	PktLen = TRP_SZEPKT;
    if ((PktLen = recvfrom (TrpSck.SckBsd, Pkt, PktLen, 0, (IPS_ADR *)&Sin, &AdrLen)) < 0)
    {
        ERR_ERR (ERR_TRP, ERR_CRITICAL, "Cannot receive trap\n");
        return (-1);
    }
	if (PktDec (Sin.sin_addr.s_addr, Msg, Pkt, PktLen) < 0)
    {
        ERR_ERR (ERR_TRP, ERR_CRITICAL, "Cannot decode trap\n");
        return (-1);
    }
    if (Pdu->TrpTyp != PKT_TRP)
    {
        ERR_ERR (ERR_TRP, ERR_CRITICAL, "Trap has wrong type\n");
        return (-1);
    }
    memcpy (Trp, Pdu, sizeof (*Trp));
    return (0);
}

/**************************************************************
** NAME:        TrpCls                                    [API]
** SYNOPSIS:    int
**                  TrpCls
**                  (
**                      void
**                  )
** DESCRIPTION: Closes a trap station.
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
int
    TrpCls
    (
        void
    )
{
    if (!TrpSck.SckOpn)
        return (-1);
    TrpSck.SckOpn = 0;
    IPS_CLS (TrpSck.SckBsd);
}


