.TH Tricklet 1 local
.SH NAME
snmp-set \- snmp SET command
.SH SYNOPSIS
.B snmp-set <host>
[
.B <community> <timeout> <retries> <port> 
] file
.SH DESCRIPTION
.I snmp-set
send snmp SET requests to the snmp agent on the specified host.
snmp-set reads line from stdin and interprets each line as a group of
snmp set requests seperated by semicolons. Such a group is send as one
SNMP message to the host. Seperate lines are send as
seperate snmp messages. Output of snmp-set is send to stdout.
.br
The format of the input to snmp-set is the same as the output
generated by snmp-get.

.SH DEFAULTS

community == "public"
.br
timeout == 5 secs
.br
retries == 3
.br
port == 161

.SH INPUT FORMAT
an input-line has the following format:

<mibvar>=<value>[;<mibvar>=<value>] 


where <mibvar> is the identifier of the requested mib
variable and <value> its future value. 

See the man page of snmp-get for a description of the value format.

.SH EXAMPLES
The following example sets the mib variable 'sysDescr' 
(system description) from the snmp agent on host dnpap.et.tuddelft.nl
and returns its new value:
.br

\<-- echo "sysDescr="new-description" | snmp-set dnpap.et.tudelft.nl secret
.br
--\> sysDescr[0]="new-description"
.br

.SH FILES
$(MIBHOME)/mibs		list of MOSY MIB definition files
$(MIBHOME)/*.defs	     MOSY MIB definitions files
.br
$(BIN)/snmp-set		executable
.SH SEE ALSO
.IR snmp-getnext(1)
.IR snmp-get(1)
.IR snmp-table(1)
.br
