/****************************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:           DNPAP.H
**      SYSTEM  NAME:           DNPAP
**      VERSION NUMBER:         1.00
**
** DESCRIPTION: This module contains general DNPAP definitions
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:        The DNPAP Group
**      CREATION DATE:          91/12/05
**      CHANGES:                None
*****************************************************************/

#ifndef DNPAPTYPES
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long  LWORD;

#if defined(__STDC__) || defined(__cplusplus) || defined(AIX)
#include <stdlib.h>
#ifndef __
#define __(a) a
#else
#error __ already defined
#endif
#define VAR_PROTO       , ...
#define VAR_ARGS        
#define VAR_DCL
#define VAR_START(va,f) va_start(va,f)
#else
#error should be an ansi compiler with __STD__
#ifndef __
#define __(a) ()
#endif
#define VAR_PROTO
#define VAR_ARGS        , va_alist
#define VAR_DCL         va_dcl
#define VAR_START(va,f) va_start(va)
#endif

/* some strange function naming problems */
#define stricmp(x,y) strcasecmp(x,y)	

/* Put reasonable defaults in some defines */
#ifndef INT_MAX           /* Some say INT_MAX, others say MAXINT */
# define INT_MAX MAXINT
/* # define time_t  LONG */
#endif
#ifndef SIG_ERR		  /* Some UNIX flavors don't define a SIG_ERR */
# define SIG_ERR -1
#endif
#ifndef CLOCKS_PER_SEC    /* Resolve a weakpoint of ANSI */
# define CLOCKS_PER_SEC   1000000L  /* number of ticks per seconds */
#endif
#ifndef CDECL		  /* Microsoft junk not used */
# define CDECL
#endif
#ifndef PASCAL		  /* Microsoft junk not used */
# define PASCAL
#endif
#ifndef VOID		  /* Some unix compilers don't know about void */
# define VOID void
#endif
#ifndef CONST		  /* Some unix compilers don't know about const */
# define CONST const
#endif
#ifndef SEEK_SET
# define SEEK_SET 0
# define SEEK_CUR 1
# define SEEK_END 2
#endif
#ifndef TRUE		  /* Not always defined, make sure it is */
# define TRUE 1
# define FALSE 0
#endif
#ifndef STATIC		  /* Easy changing of static to non-static */
# define STATIC static
#endif

#define DNPAPTYPES
#endif
