#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define SERVER "scsnms.switch.ch"
#define PORT "1234"
#define PORT_NO (htons((u_short)1234))

#include <signal.h>
#include <stdio.h>

#define N_LINES 64
#define TRUE (1)
#define FALSE (0)

#include "defs.h"

extern int debug;

int highlight [N_LINES];
char lines [N_LINES][64];
int i, n_lines;

static int	skt;
static struct timeval notime = {0,0};
static struct timeval time_wait = {120,120};

int invers, i, len;
char buffer [512];

char peername[] = SERVER;

connect_server(  )
  {
    /*SERVICE_ENTRY*      sp;*/
    struct sockaddr_in	server;
    u_short		port;
    u_long addr;
    struct hostent *hp;



/*
    if( (sp=getservbyname(PORT,"tcp")) != 0 )
	port = sp->s_port;
    else if( (port=htons((u_short)sdec(PORT,0))) <= 0 )
      {
        fprintf(stderr, "Cannot recognise PORT %s\n", PORT);
        exit();
      }
*/
    if ((addr = inet_addr(peername)) != -1){
        bcopy((char *)&addr, (char *)&server.sin_addr, 
           sizeof(server.sin_addr));
    } else {
        hp = gethostbyname(peername);
        if (hp == NULL){
            fprintf(stderr, "unknown host: %s\n", peername);
            exit(1);
        } else {
            bcopy((char *)hp->h_addr, (char *)&server.sin_addr, hp->h_length);
        }
    }
    server.sin_family = AF_INET;
    port = PORT_NO;
    server.sin_port	     = port;

    if( (skt=socket(AF_INET,SOCK_STREAM,0)) < 0 )
      {
        perror ("Error in socket call");
        exit(1);
      }

    if( connect(skt,&server,sizeof(server)) < 0 )
      {
        perror ("cannot connect");
	exit(1);
      
      }	
    if (debug)
       fprintf(stderr, "Connected to server\n");
}


read_data(Wait)
int Wait;
{
int i;
fd_set r_flag, w_flag, x_flag;

       if (!(Wait)) {
           FD_ZERO (&r_flag);
           FD_ZERO (&x_flag);
           FD_ZERO (&w_flag);
           FD_SET  (skt, &r_flag);
           select (getdtablesize(), &r_flag, &w_flag, &x_flag, &notime);
           if (!(FD_ISSET(skt, &r_flag))) 
		return (E_NODATA);
       }

restart:
    for (i = 0; i<N_LINES; i++) {

        FD_ZERO (&r_flag);
        FD_ZERO (&x_flag);
        FD_ZERO (&w_flag);
        FD_SET  (skt, &r_flag);
        select (getdtablesize(), &r_flag, &w_flag, &x_flag, &time_wait);
        if (!(FD_ISSET(skt, &r_flag))) 
		return (E_NODATA);

        for (len=0; ; len++)  {
            if ( read (skt, &buffer[len], 1)  != 1) {
            perror ("Error in reading from server");  exit ();
          }
          if (buffer[len] == 10) break;
        }
        if (buffer[0] == '#') {
           if (buffer[1] == 'R') {
              n_lines = i;
              return(OK);
	   }
           else if (buffer[1] == 'C') {
              return(RESTART);
           } else {
              goto restart;
           }
        } else {
           buffer [len]=0;
           if (sscanf (buffer, " %4d ", &highlight[i]) != 1)
               fprintf (stderr, "Error in sscanf\n");; 
      /*printf ("Line %d Higlight %d,  str=<%s>\n", 
          i, highlight[i],  buffer);*/
           if (highlight[i] < 0) highlight[i] = 2;
           strcpy (lines[i],  &buffer[5]);
        }
   }

}

int close_connection()
{
	return close(skt);
}
