/*
      partyIdentity          Party,
      partyTDomain           OBJECT IDENTIFIER,
      partyTAddress          TAddress,
      partyProxyFor          Party,
      partyAuthProtocol      OBJECT IDENTIFIER,
      partyAuthClock         TimeTicks,
      partyAuthPublic        OCTET STRING,
      partyAuthLifetime      INTEGER,
      partyPrivProtocol      OBJECT IDENTIFIER,
      partyPrivPublic        OCTET STRING
      partyMaxMessageSize    INTEGER
      partyStatus	     INTEGER

      partySecretsIdentity   Party,
      partySecretsAuthPrivate OCTET STRING,
      partySecretsPrivPrivate OCTET STRING,
      partySecretsStatus      INTEGER
 */

#define PARTYIDENTITY           1
#define PARTYTDOMAIN            2
#define PARTYTADDRESS           3
#define PARTYPROXYFOR           4
#define PARTYAUTHPROTOCOL       5
#define PARTYAUTHCLOCK          6
#define PARTYAUTHPUBLIC         7
#define PARTYAUTHLIFETIME       8
#define PARTYPRIVPROTOCOL       9
#define PARTYPRIVPUBLIC         10
#define PARTYMAXMESSAGESIZE	11
#define PARTYSTATUS		12
#define PARTYSECRETSIDENTITY    13
#define PARTYSECRETSAUTHPRIVATE 14
#define PARTYSECRETSPRIVPRIVATE 15
#define PARTYSECRETSSTATUS      16

#define PARTYNONEXISTENT 	0
#define PARTYVALID		1
#define PARTYINVALID		2

#define DOMAIN1351	1
extern oid rfc1351Domain[];
#define DOMAINSMPUDP	2
extern oid smpUdpDomain[];
/* no others defined yet */

#define NOAUTH		1
extern oid noAuth[];
#define MD4AUTHPROT	2	/* unused - historical */

#define NOPRIV		3
extern oid noPriv[];
#define DESPRIVPROT	4
extern oid dESPrivProt[];
#define MD5AUTHPROT	5
extern oid mD5AuthProt[];
#define SMPMD5AUTHPROT	6
extern oid smpMD5AuthProt[];

#define NOPROXY		1
extern oid noProxy[];


struct partyEntry {
    oid		partyIdentity[32];
    int		partyIdentityLen;
    char	partyName[64];	/* friendly name */
    int		partyTDomain;
    u_char	partyTAddress[16];
    int		partyTAddressLen;
    oid		partyProxyFor[32];
    int		partyProxyForLen;
    int		partyAuthProtocol;
    u_long	partyAuthClock;
    u_long	partyLastTimeStamp;	/* not in MIB */
    long	partyAuthNonce;
    u_char	partyAuthPublic[32];
    int		partyAuthPublicLen;
    u_long	partyAuthLifetime;
    int		partyPrivProtocol;
    u_char	partyPrivPublic[32];
    int		partyPrivPublicLen;
    int		partyMaxMessageSize;

/*    oid		partySecretsIdentity[64];  -- same as partyIdentity */
    u_char	partySecretsAuthPrivate[16];
    int		partySecretsAuthPrivateLen;
    u_char	partySecretsPrivPrivate[16];
    int		partySecretsPrivPrivateLen;
    int		partySecretsStatus;
    
    u_long	partyBitMask;

    struct partyEntry *reserved;
    struct partyEntry *next;
    struct timeval tv;
};

u_char *var_party();
int write_party();

struct partyEntry *
party_getEntry(/* oid *partyID, int partyIDLen */);
/*
 * Returns a pointer to the partyEntry with the
 * same identity as partyID.
 * Returns NULL if that entry does not exist.
 */

party_scanInit();
/*
 * Initialized the scan routines so that they will begin at the
 * beginning of the list of partyEntries.
 *
 */


struct partyEntry *
party_scanNext();
/*
 * Returns a pointer to the next partyEntry.
 * These entries are returned in no particular order,
 * but if N entries exist, N calls to party_scanNext() will
 * return all N entries once.
 * Returns NULL if all entries have been returned.
 * party_scanInit() starts the scan over.
 */

struct partyEntry *
party_createEntry(/* oid *partyID, int partyIDLen */);
/*
 * Creates a partyEntry with the given index
 * and returns a pointer to it.
 * The status of this entry is created as invalid.
 */


