#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include "asn1.h"
#include "view.h"

#define TRUE 1
#define FALSE 0

static error_exit(str, linenumber, filename)
    char *str;
    int linenumber;
    char *filename;
{
    fprintf(stderr, "%s on line %d of %s\n", str, linenumber, filename);
    exit(1);
}

int
read_view_database(filename)
    char *filename;
{
    FILE *fp;
    char buf[256], buf1[256], buf2[256], buf3[256], buf4[256];
    char *cp;
    int blank, nonhex;
    int linenumber = 0;
    oid viewParty[64], viewSubtree[64];
    int viewPartyLen, viewSubtreeLen;
    int status;
    u_long byte;
    u_char mask[16], *ucp;
    int maskLen;
    struct viewEntry *vwp;

    fp = fopen(filename, "r");
    if (fp == NULL)
	return 0;
    while (fgets(buf, 256, fp)){
	linenumber++;
	if (strlen(buf) > 250)
	    error_exit("Line longer than 250 bytes", linenumber, filename);
	if (buf[0] == '#')
	    continue;
	blank = TRUE;
	for(cp = buf; *cp; cp++)
	    if (!isspace(*cp)){
		blank = FALSE;
		break;
	    }
	if (blank)
	    continue;

	if (sscanf(buf, "%s %s %s %s", buf1, buf2, buf3, buf4) != 4)
	    error_exit("Bad parse", linenumber, filename);
	viewPartyLen = 64;
	if (!read_objid(buf1, viewParty, &viewPartyLen))
	    error_exit("Bad object identifier", linenumber, filename);

	viewSubtreeLen = 64;
	if (!read_objid(buf2, viewSubtree, &viewSubtreeLen))
	    error_exit("Bad object identifier", linenumber, filename);

	if (!strcasecmp(buf3, "included"))
	    status = VIEWINCLUDED;
	else if (!strcasecmp(buf3, "excluded"))
	    status = VIEWEXCLUDED;
	else
	    error_exit("Bad status field", linenumber, filename);

	if (strlen(buf4) % 2)
	    error_exit("Bad mask (should be an even number of hex digits)",
		       linenumber, filename);
	nonhex = 0;
	for(cp = buf4; *cp; cp++){
	    if (!isxdigit(*cp))
		nonhex = 1;
	}
	if (nonhex){
	    if (strcasecmp(buf4, "Null"))
		error_exit("Bad private key value (should be hex digits or null)",
			   linenumber, filename);
	    maskLen = 0;
	} else {
	    ucp = mask;
	    for(cp = buf4; *cp; cp += 2, ucp++){
		if (sscanf(cp, "%2x", &byte) != 1)
		    error_exit("Bad parse", linenumber, filename);
		*ucp = byte;
	    }
	    maskLen = ucp - mask;
	}
	

	vwp = view_getEntry(viewParty, viewPartyLen,
			    viewSubtree, viewSubtreeLen);
	if (!vwp)
	    vwp = view_createEntry(viewParty, viewPartyLen,
				 viewSubtree, viewSubtreeLen);
	vwp->viewStatus = status;
	vwp->viewMaskLen = maskLen;
	bcopy(mask, vwp->viewMask, maskLen);
#define VIEWCOMPLETE_MASK              15
	/* all collumns - from view_vars.c XXX */
	vwp->viewBitMask = VIEWCOMPLETE_MASK;
	vwp->reserved->viewBitMask = vwp->viewBitMask;
    }
    fclose(fp);
    return 1;
}

