;
;
;  Usage :
;	    -pktentry
;           _pktasminit( void far * buffers, int maxbufs, int buflen)
;
;  (c) 1991 University of Waterloo,
;           Faculty of Engineering,
;           Engineering Microcomputer Network Development Office
;
;  version
;
;    0.1    22-May-1992   E. P. Engelke
;
;
        include masmdefs.hsm
        include model.hsm

ORIGINAL  equ  0         ; AU

	cextrn	pkt_rcv_call1
	cextrn	pkt_rcv_call2

codedef ASMPKT
datadef

datastart
STACK_FILL      equ     0CC33H  ; Stack for AU interrupt handler
ISTACK_SIZE     equ     512     ; bytes
        dw      256 dup (STACK_FILL)
END_ISTACK      equ     $
dataend

cstart  ASMPKT

   if  ORIGINAL  ; AU
maxbufs	dw	?
maxlen	dw	?
bufs	dw	?
bufseg	dw	?
   endif   ; ORIGINAL

helper_ds	DW	?
helper_ss	DW	?
helper_sp	DW	?

cproc	_pktentry       ; AU: packet receive code from pcip

	ASSUME	DS:NOTHING, SS:NOTHING, ES:NOTHING
	; Squirrel away the packet driver's critical registers...

	mov	helper_ds,ds
	mov	helper_ss,ss
	mov	helper_sp,sp

	or	ax,ax		; First or second call?
				; DON'T DO ANYTHING TO CHANGE FLAGS
				; UNTIL THE JNZ SECOND_CALL, BELOW

	; Get a stack and a way to reach our data segment...
	; MOV instructions don't affect the flags
	mov	ax,DGROUP
	mov	ss,ax
	ASSUME	SS:DGROUP
	mov	ds,ax
	ASSUME	DS:DGROUP
	mov	sp,OFFSET DGROUP: END_ISTACK

	; Save some of the packet driver's other registers...
	pushf			; Preserve direction-flag and int-flag

	cld			; Microsoft C needs this, doesn't
				; harm the flags set by the or ax,ax
				; above

	jnz	short second_call	; Check result of or ax,ax
					; way above
	push	cx		; len
	push	bx		; handle
	ccall	pkt_rcv_call1	; First call returns a far pointer
				; in dx (segment) & ax (offset)
	add	sp,4		; Remove the parameters from the stack
	mov	es,dx		; segment of far ptr returned
	mov	di,ax		; offset of far ptr returned
help_ret:
	popf			; Restore int status and direction flag
	mov	ds,helper_ds
	ASSUME	DS:NOTHING
	mov	ss,helper_ss
	ASSUME	SS:NOTHING
	mov	sp,helper_sp
	retf

	ASSUME	DS:DGROUP, SS:DGROUP
second_call:
	push	ds		; Segment part of buffer
	push	si		; Offset part of buffer
	push	cx		; len
	push	bx		; handle
	ccall	pkt_rcv_call2	; Nothing returned
	add	sp,8		; Remove the parameters from the stack
	jmp	short help_ret
cendp   _pktentry

   if  ORIGINAL  ; AU
cproc	_pktentry
	pushf

	cli		; no interruptions now

	or	AL, AL
	jnz	encue	; branch if was a 1 and must encue packet now

	; buffer request operation
	; to check our buffers we will need the same DS seg, set it now
        push    CX
	push	DS
        mov     DI, CS:bufseg
        mov     DS, DI

	; check the packet length
	cmp	CX, cs:maxlen
	jg	no_fnd		; pretend none were found

	mov	DI, CS:bufs
	mov	CX, CS:maxbufs
	mov	AL, 0ffh

srcloop:test    AL, byte ptr DS:DI
	jz	found
	add	DI, CS:maxlen
	add	DI, 2
	loop	srcloop

no_fnd: xor	DI, DI		; for whatever error, throw away the buffer
	mov	DS, DI		; by returning 0000:0000
	sub	DI, 2

found:  mov     AL,1
        mov     byte ptr DS:DI,AL       ; mark in use
;
        push	DS
	pop	ES
	add	DI, 2
	pop	DS
	pop	CX
	popf
	retf

	; encue packet
	;
encue:	or	SI, SI
	jz	no_enqu		; not a valid pointer, cannot encue
	push	SI
	sub	SI, 2
;	mov	AL, 1		; should be already, but just in case
;        mov     byte ptr DS:SI, AL
	pop	SI
no_enqu:popf
	retf
cendp   _pktentry

cpublic _pktasminit		; bufptr, maxbufs, buflen
	mov	AX, +@AB + 0 [BP]	; bufptr
	mov	BX, +@AB + 2 [BP]	; bufptr segment
	mov	CX, +@AB + 4 [BP]	; maxbufs
	mov	DX, +@AB + 6 [BP]	; buflen
	mov	CS:bufs, AX
	mov	CS:bufseg, BX
	mov	CS:maxbufs, CX
	mov	CS:maxlen, DX
creturn _pktasminit
   endif   ; ORIGINAL

cend    ASMPKT
        end
