#include <stdio.h>
#include <alloc.h>

#define NULL  0

#include "autree.h"

struct node_header ftree; /* Root of tree */

int nbr_nodes;
int cmp_count;

struct node *new_node(t)
int t;
{
   struct node_header *q;
   int size = sizeof(struct node_header);
   if (t == N_FLOW) size += sizeof(struct flow);
   else if (t == N_BACK_FLOW) size += sizeof(struct back_flow);
   if ((q = malloc(sizeof(struct node))) == NULL) {
      printf("No memory for new node!\n");
      return (struct node *)NULL;
      }
   q->llink = q->rlink = NULL;
   q->balance = 0;
   q->type = t;
   ++nbr_nodes;
   return (struct node *)q;
   }

int compare(n1,n2)
struct node *n1,*n2;
{
   ++cmp_count;
   if (n1->i.f.key < n2->i.f.key) return -1;
   if (n1->i.f.key > n2->i.f.key) return 1;
   return 0;
   }

void insert_key(q,n)  /* Insert key data from n into q */
struct node *q, *n;
{
   q->i.f.key = n->i.f.key;
   }

#define link(a,p)  (a == -1 ? p->h.llink : p->h.rlink)
#define setlink(a,p, v)  if (a == -1) p->h.llink = v; else p->h.rlink = v

struct node *hbtree(n,compfn, type, tree)  /* Find node n in tree */
struct node *n;
int (*compfn)();
int type;  /* Type of node to add: N_VOID -> don't add new node */
struct node_header *tree;
{
   struct node *t,  /* Father of s */
      *s,  /* Place where rebalancing may be neccessary */
      *p,
      *q,*r;
   char a;
   t = (struct node *)tree;  /* A1: Initialise */
   s = p = t->h.rlink;
   if (p == NULL) {  /* Empty tree */
      if (type == N_VOID) return NULL;
      if ((q = new_node(type)) == NULL) return q;
      t->h.rlink = q;
      insert_key(q,n);
      tree->balance = 1;
      return q;
      }
   for (;;) {  /* A2: Compare */
      if ((a = (*compfn)(n,p)) == 0) return p;  /* Success */
      if (a < 0) {
	 if ((q = p->h.llink) == NULL) {  /* A3: Move left */
	    if (type == N_VOID) return NULL;
	    if ((q = new_node(type)) == NULL) return q;
	    p->h.llink = q;
	    break;
	    }
	 }
      else {  /* A4: Move right */
	 if ((q = p->h.rlink) == NULL) {
	    if (type== N_VOID) return NULL;
	    if ((q = new_node(type)) == NULL) return q;
	    p->h.rlink = q;
	    break;
	    }
	 }
      if (q->h.balance != 0) {
	 t = p;  s = q;
	 }
      p = q;
      }
   insert_key(q,n);  /* A5: Insert */  /* !@! */
   if ((*compfn)(n,s) < 0)  /* A6: Adjust balance factors */
      r = p = s->h.llink;
   else
      r = p = s->h.rlink;
   while (p != q) {
      if ((*compfn)(n,p) < 0) {
	 p->h.balance = -1;  p = p->h.llink;
	 }
      else {
	 p->h.balance = 1;  p = p->h.rlink;
	 }
      }
   a = (*compfn)(n,s) < 0 ? -1 : 1;  /* A7: Balancing act */
   if (s->h.balance == 0) {  /* Tree has grown higher */
      s->h.balance = a;  ++tree->balance;
      return q;
      }
   if (s->h.balance == -a) {  /* Tree balance has improved */
      s->h.balance = 0;
      return q;
      }
   /* Tree has become unbalanced */
   if (r->h.balance == a) {  /* A8: Single rotation */
      p = r;
      setlink(a,s, link(-a,r));
      setlink(-a,r, s);
      s->h.balance = r->h.balance = 0;
      }
   else {  /* A9: Double rotation */
      p = link(-a,r);
      setlink(-a,r, link(a,p));
      setlink(a,p, r);
      setlink(a,s, link(-a,p));
      setlink(-a,p, s);
      if (p->h.balance == a) {
	 s->h.balance = -a;  r->h.balance = 0;
	 }
      else if (p->h.balance == 0) {
	 s->h.balance = r->h.balance = 0;
	 }
      else {
	 s->h.balance = 0;  r->h.balance = a;
	 }
      p->h.balance = 0;
      }
   if (s == t->h.rlink) t->h.rlink = p;  /* A10: Finishing touch */
   else t->h.llink = p;
   return q;
   }

void ptree(t,d)
struct node *t;
int d;
{
   int j;
   if (t->h.llink) ptree(t->h.llink,d+1);
   for (j = 0; j != d; ++j) printf("   ");
   printf("%c(%d)\n",t->i.f.key,t->h.balance);
   if (t->h.rlink) ptree(t->h.rlink,d+1);
   }

void main()
{
   struct node data;
   int c;

   for (;;) {
      c = getchar();
      if (c == '!') exit();

      data.i.f.key = c;
      cmp_count = 0;
      hbtree(&data,compare, N_FLOW, &ftree);

      ptree(ftree.rlink,0);
      printf("key=%c, nodes=%d, height=%d, compares=%d\n\n",
	 c,nbr_nodes,ftree.balance,cmp_count);

      getchar();  /* Ignore \n */
      }
   }