/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The remote demon for benchmark programs
 *
 * Swicthes:
 *	-n	No logging - don't supply a log file name
 *      -r Print statistics from Responder
 *
 *	-d Debug on (all)			(dprintf)
 *	-t Trace on - tracing procedures	(tprintf)
 *	-p Protocol Debug on 			(pprintf)
 *	-s State Trace on			(stprintf)
 *	-i IPC Trace on 			(iprintf)
 *	-m Measurement procedure debug		(mprintf)
 *
 * Parameters:
 *	Logfile
 *
 */
/********************
 *
 *      Revision: Responder switch 'r' added 1189/ PerG
 *
 */

#include <general.h>

/*  */
int PrintResponder = 0;
int Trace = 0, Debug = 0;
int ProtoDebug = 0, StateTrace = 0, IPCTrace = 0, ProcDebug = 0;

int Log = 1;
int NoEcho = 0;

char DefServerHost[] = "(default server)";
char DefClientHost[] = "(default client)";

char *myname;

#define BUFSIZE 128

/*  */

main(argc, argv)
    int argc;
    char **argv;
{
    char logname[BUFSIZE];
    long secs;

    myname  = argv[0];
    
    argv++, argc--;
    while (argc > 0 && *argv[0] == '-') {
	getflags(argv[0]);
	argv++, argc--;
    }
    
    if ((Log && argc != 1) || (!Log && argc != 0)) {
	fprintf(stderr, "Usage: %s [-ntdpism] [<logfile>]\n", myname);
	exit(1);
    }

    init_stdio();
    if (Log) {
	strncpy(logname, argv[0], BUFSIZE);
	initlog(logname);
    }

#ifdef SYSV
    setpgrp();
#endif SYSV    

    symtab_init();

    /* Enter benchmark and distribution names into the symbol table */
    autoinit();

    secs = time(NULL);
    logmsg("Demon process starting, pid = %d\n", getpid());
    logmsg("\tat %s\n", ctime(&secs));

    demon_server();

    secs = time(NULL);
    logmsg("Demon process terminated at %s\n", ctime(&secs));

} /* main */

/*  */

getflags(str)
    char *str;
{
    str++;	/* skip '-' */
    while (*str != '\0') {
	switch (*str) {
	case 'n':
	    Log = 0;
	    break;

	case 'r':
	    PrintResponder = 1;
	    break;
	    
	case 'd':
	    Debug = 1;
	    Trace = 1;
	    ProtoDebug = 1;
	    IPCTrace = 1;
	    StateTrace = 1;
	    ProcDebug = 1;
	    break;
	case 't':
	    Trace = 1;
	    break;
	case 'p':
	    ProtoDebug = 1;
	    break;
	case 'i':
	    IPCTrace = 1;
	    break;
	case 's':
	    StateTrace = 1;
	    break;
	case 'm':
	    ProcDebug = 1;
    	    break;

	default:
	    fprintf(stderr, "%s: unknown flag -%c\n", myname, *str);
	    exit(1);
	}
	str++;
    }
} /* getflags */

