/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The logger for the demon process
 *
 * Catches everything on stderr, and normal printf's
 * (but NOT fprintf(stdout, ..).
 */

#include <general.h>

/*
 * Exports:
 *	initlog(name: char *)
 *	logmsg(a: char *,...) 
 */

FILE *logfile = stderr;
extern int Log;

initlog(name)
    char *name;
{
    if ((logfile = freopen(name, "a", stderr)) == NULL) {
	eprintf("Failed opening the log file %s due to %s!\n",
		name, getsyserr());
	return NOTOK;
    }
#ifdef BSD
    setlinebuf(logfile);
#endif BSD
#ifdef SYSV
    if (setvbuf(logfile, NULL, _IOLBF, 0) != 0) {
    	eprintf(EF_IN3, INTERNAL, "setvbuf", "init");
    	exit(2);
    }
#endif SYSV
    if ((logfile = freopen(name, "a", stdout)) == NULL) {
	eprintf("Failed opening the log file %s due to %s!\n",
		name, getsyserr());
	return NOTOK;
    }
#ifdef BSD
    setlinebuf(logfile);
#endif BSD
#ifdef SYSV
    if (setvbuf(logfile, NULL, _IOLBF, 0) != 0) {
    	eprintf(EF_IN3, INTERNAL, "setvbuf", "init");
    	exit(2);
    }
#endif SYSV
    return OK;
} /* initlog */

/* VARARGS1 */
logmsg(str,a,b,c,d,e,f,g,h)
    char *str;
{
    if (!Log)
	return;
    fprintf(stderr, str, a,b,c,d,e,f,g,h);
} /* logmsg */

/* VARARGS1 */
printf(str,a,b,c,d,e,f,g,h)
    char *str;
{
    logmsg(str,a,b,c,d,e,f,g,h);
} /* printf */
