/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Conversion
 */

/*
 * TODO
 * 	The correctness of the code relies on MT_UNDEF and ST_UNDEF having
 *	the same value
 */

/*
 * Exports:
 * 	Metrics2Stats(mt: metrics_t *; st: statistics_t *)
 */

#include <general.h>


Metrics2Stats(mt,st)
    metrics_t *mt;
    statistics_t *st;
{
    tprintf("Metrics2Stats(0x%x, 0x%x)\n", mt, st);
    
    st->st_exitstatus = (double)Metrics2Exit(mt);
    st->st_starttime = Metrics2Starttime(mt);
    st->st_stoptime = Metrics2Stoptime(mt);
    st->st_elapsed = (double)Metrics2Elapsed(mt);
    st->st_cputime = (double)Metrics2Cputime(mt);
    st->st_stime = (double)Metrics2Systime(mt);
    st->st_utime = (double)Metrics2Usertime(mt);
    st->st_delay = 1000*Metrics2Delay(mt); 	 /* convert to millisecs */
    st->st_datasent = (double)Metrics2Sentdata(mt);
    st->st_datarcvd = (double)Metrics2Recvdata(mt);
    st->st_msgsent = (double)Metrics2Sentmsg(mt);
    st->st_msgrcvd = (double)Metrics2Recvmsg(mt);
    st->st_packsent = (double)Metrics2Opackets(mt);
    st->st_packrcvd = (double)Metrics2Ipackets(mt);
    st->st_signals = (double)Metrics2Recvsignals(mt);
    st->st_blockout = (double)Metrics2Oblock(mt);
    st->st_blockin = (double)Metrics2Iblock(mt);
    st->st_pageio = (double)Metrics2Pfio(mt);
    st->st_pagerecl = (double)Metrics2Pfrecl(mt);
    st->st_swaps = (double)Metrics2Swaps(mt);
    st->st_ivcsw = (double)Metrics2Ivcsw(mt);
    st->st_vcsw = (double)Metrics2Vcsw(mt);
    st->st_maxrss = (double)Metrics2Memusage(mt);
} /* Metrics2Stats */
