/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Header file for benchmarks on the FTAM protocol
 */

#ifndef __FTAM__
#define __FTAM__

#include <isode/ftam.h>
#include <isode/tsap.h>

/*
 * Default values
 */
#define FTAM_MANAGE	0	/* no presentation context management */
#define FTAM_LEVEL	FLEVEL_RELIABLE 
#define FTAM_CLASS	FCLASS_TRANSFER
#define FTAM_UNITS	(FUNIT_READ | FUNIT_WRITE | FUNIT_GROUPING)
#define FTAM_ATTRS	FATTR_STORAGE
#define FTAM_ROLLBACK	0	/* no rollback */

/* Added ascii support 890209  /janeriks */
#ifdef ASCII
#define VF_INDEX	2
#else
#define VF_INDEX	1
#endif

#include "../protoaddrs/psapaddr.h"

/* A channel is an assocation descriptor */
typedef int 		channel_t;
#define server_t	address_t	/* a struct PSAPaddr */


/*
 * Error handling
 */
typedef struct {
    int er_ret;
    int er_tag;
    union {
	struct FTAMindication eru_fti;
	struct TSAPdisconnect eru_td;
    } er_u;
#define er_fti	er_u.eru_fti
#define er_td	er_u.eru_td    
} error_t;

#define ERT_NONE	0	/* THe error has already been reported */
#define ERT_FTI		1
#define ERT_TD		2


#define failed(errind)	((errind)->er_ret == NOTOK)

#define report_error(errind,str)	ftam_report_error(errind,str)


#define InitClient	ftam_init_client

#define ConnRequest(addr,a_ch,errind) \
    				ftam_conn_request(addr, a_ch, errind)
#define DiscRequest(ch, errind) \
    				ftam_disc_request(ch, errind)
#define AwaitConnInd(serverp, a_ch, errind) \
			    	ftam_await_conn_ind(serverp, a_ch, errind)

#define AwaitDiscInd(ch, errind) \
    				ftam_await_disc_ind(ch, errind)



#define CreateServer(aa_server, aa_addr, errind) \
    				ftam_create_server(aa_server, aa_addr, errind)
#define DestroyServer(a_server, errind) \
    				ftam_destroy_server(a_server, errind)

#define DataRequest(channel,buffer,amount, errind) \
				ftam_data_request(channel,buffer,amount,errind)

#define AwaitDataIndication(channel, buffer, amount, errind)	\
			ftam_await_data_ind(channel,buffer,amount,errind)

#define BulkGetDataReq		DataRequest
#define BulkPutDataReq  	DataRequest
#define BulkGetAwaitDataInd	AwaitDataIndication
#define BulkPutAwaitDataInd	AwaitDataIndication

#define BulkGetStart 		ftam_start_bulk_get
#define BulkGetStop		ftam_stop_bulk_get
#define AwaitBulkGetStart 	ftam_await_start_bulk_get
#define AwaitBulkGetStop	ftam_await_stop_bulk_get
#define BulkPutStart 		ftam_start_bulk_put
#define BulkPutStop		ftam_stop_bulk_put
#define AwaitBulkPutStart 	ftam_await_start_bulk_put
#define AwaitBulkPutStop	ftam_await_stop_bulk_put

/*
 * Stolen from isode/3.0/ftam2/ftamsbr.h
 */
struct vfsmap {
    char   *vf_entry;		/* document entry */
    OID	    vf_oid;		/* object identifier */

    int     vf_flags;		/* flags */
#define	VF_NULL	0x00
#define	VF_OK	0x01		/* negotiated */
#define	VF_WARN	0x02		/* warn if loses */

    int	    vf_id;		/* presentation context */

    int	    vf_mode;		/* st.st_mode & S_IFMT bits */
    char    vf_stat;		/* stat character for 'ls' */

    IFP	    vf_check;		/* contents check */

    int	    vf_simplify;	/* the next document type to try */
#define	VFS_XXX	(-1)

    int	    vf_context;		/* access context */
				/* really should have entire constraint set */

    char  *vf_text;		/* textual description */
};

#endif __FTAM__
