/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Addresses used for SunLink OSI protocols
 */

#ifndef __SUNOSIADDR__
#define __SUNOSIADDR__

#ifndef __OSI__
#define __OSI__
#include <sys/socket.h>
#include <sys/ieee802.h>
#include <netosi/osi.h>    
#include <netosi/osi_addr.h>    
#include <netosi/osi_profile.h>
#include <netosi/osi_error.h>
#include <netosi/osi_layer.h>
#include <netosi/tp_event.h>
#endif __OSI__

/* The address is a OSI_ADDR structure. OSI_ADDR is typedef'd, so
 * address_t cannot be #defined to be a OSI_ADDR, since address_t is
 * (precipitately) supposed to be a structure. 
 */

struct address_t {
    OSI_ADDR osi_addr;
};

/*
 * osi_address(OSI_ADDR *) is used for generating a (hopefully) unique
 * SunLink OSI address
 */

OSI_ADDR *osi_address();

/*
 * Routines for address handling
 *
 * str2address(char *; int *) -> address_t *	(dynamically allocated result)
 * address2str(address_t *; int *) -> char *	(dynamically allocated result)
 * void address_free(address_t *)	(free dynamically allocated data)
 * address_copy(address_t *) -> address_t *	(dynamically allocated result)
 *
 */
#endif __SUNOSIADDR__
