/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Address specific code: addresses being OSI_ADDR
 * The same address handling can be used for all layers, provided that 
 * complete NSAP addresses always are used. 
 * (Otherwise the osi_parseaddr call needs to be different for all layers)
 */

#include <general.h>
#include "../protoaddrs/sunosiaddr.h"

/*  */

struct address_t *str2address(str, a_len)
    char *str;
    int *a_len;
{
    int len = *a_len;	/* total length */
    int used;		/* used (read) length */
    OSI_ADDR osiaddr;
    struct address_t addrs, *addr = &addrs, *res;
    char *this, *next;

    pprintf("str2address(0x%x, 0x%X, len %d)\n", str, a_len, *a_len);

    OSI_ADDR_INIT(&osiaddr);
    if (OSI_PARSE_OK != osi_parseaddr(str, &osiaddr, OSI_PSAP)) {
	pprintf(EF_IN3, INTERNAL, PROTOCOL, "str2address - osi_parseaddr");
	return NULL;
    }
    res = (struct address_t *) malloc(sizeof(struct address_t));
    if (res == NULL) {
	pprintf(EF_IN4X, INTERNAL, RESOURCE, "str2address",
		"malloc failed");
	return NULL;
    }
    res->osi_addr = osiaddr; /* struct copy */
    /* a_len = a_len, since all of a_len has been used */
    return res;
}

/*  */

#define BUFSIZE 256


char *address2str(addr, a_len)
    struct address_t *addr;
    int *a_len;
{
    char *str, *res;
    int len;
    static char buf[BUFSIZE];
    
    pprintf("address2str(0x%x, 0x%x)\n",
		addr, a_len);;
    
    
    str = buf;
    if (NULL == osi_sprintaddr(str, &addr->osi_addr)) {
	pprintf(EF_IN3, INTERNAL, PROTOCOL, "address2str - osi_sprintaddr");
	return NULL;
    }
    len = strlen(str);
    if (len >= BUFSIZE) {
	pprintf(EF_IN3, INTERNAL, "buffer overflow", "address2str");
	return NULL;
    }

    len++;	/* include NULL char */
    res = (char *)malloc(len);
    if (res == NULL) {
	pprintf(EF_IN4X, INTERNAL, RESOURCE, "address2str",
		"malloc failed");
	return NULL;
    }

    bcopy(buf, res, len);

    *a_len = len;

    pprintf("<address2str: %s.\n", res);

    return res;
} /* address2str */

/*  */

void address_free(addr)
    struct address_t *addr;
{
    pprintf("address_free(0x%x)\n", addr);

    free((char *)addr);
} /* address_free */

/*  */

struct address_t *address_copy(addr)
    struct address_t *addr;
{
    struct address_t *res;

    pprintf("address_copy(0x%x)\n", addr);
    res = (struct address_t *)malloc(sizeof(struct address_t));
    if (res == NULL) {
	pprintf(EF_IN4X, INTERNAL, RESOURCE, "address_copy",
		"malloc failed");
	return NULL;
    }

    *res = *addr;
    return res;
} /* address_copy */


/*
 * Make up a complete osi address. Organisation and subnetwork number are
 * #defined by OSI_ORG and OSI_SUBNET, and "spimsnnn" is used as transport
 * and session selectors, where nnn is the pid of the current process.
 * Dig up the Ethernet number by means of Internet functions, and use that
 * as the subnetwork point of attachment
 */

#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

OSI_ADDR *osi_address(oap)
OSI_ADDR *oap;
{

    char buf[BUFSIZ];
    char eabuf[128], *ea;
    struct ether_addr eaddr;
    char *ether_ntoa();
    
#define HOSTNAMELEN 64
    char hostname[HOSTNAMELEN];

    gethostname(hostname, sizeof(hostname));
    ether_hostton(hostname, &eaddr);
    ea = ether_ntoa(&eaddr);
    
    OSI_ADDR_INIT(oap);

    sprintf(buf, "[(osinet)%d,%d; (802.osinet)%s; 0] [(tsel-s)\"spims%d\"] [(ssel-s)\"spims%d\"]",
	    OSI_ORG, OSI_SUBNET, ea, getpid(), getpid());
    if (osi_parseaddr(buf, oap, OSI_PSAP) < 0) {
	eprintf(EF_IN4, COMMUNICATION, "OSI parseaddr failed on ", buf,
		"osi_parseaddr");
	return (OSI_ADDR *) 0;
    }
    pprintf("Osi parse address ok: %s\n", osi_sprintaddr(buf, oap));
    return oap;
}
