/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring two-way delay including connection
 * setup and taredown (excluding session).
 *
 * Same as rpc. However rpcid does idempotent responses.
 *
 * Parameters:
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>

int rpci(be, addr, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct address_t 	*addr;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    INITIATOR_VARIABLES;
    TIMING_VARIABLES(0);
    int 		msgsize1, msgsize2;
    channel_t 		ch;

    TIMING_INITIATE(0);

    mprintf("rpci(src 0x%x, dst 0x%x, mt 0x%x)\n",
		srchdl, dsthdl, mt);

    ConnRequest(addr, &ch, &error);
    if (failed(&error)) {
	report_error(&error, "ConnRequest");
	return NOTOK;
    }
    
    INITIATOR_BEFORE_START;
    
    StartMeasurements(mt);

    INITIATOR_AFTER_START;

    for (i = 0; i < iterations; i++) {
	if (interupted)
	    break;
	INITIATOR_SENDSIZE(msgsize1, i);
	if ((*srchdl->io_get)(srchdl, msgsize1) == NOTOK) {
	    report_error(NULL, "io_get");
	    return NOTOK;
	}

	INITIATOR_RECVSIZE(msgsize2, i);

	RPCCall(ch, srchdl->io_bufptr, msgsize1, dsthdl->io_bufptr,
		    msgsize2, &error);
	if (failed(&error)) {
	    report_error(&error, "RPCCall");
	    return NOTOK;
	}
	    
	MetricsAddDatasent(mt, msgsize1);
	MetricsAddDatarcvd(mt, msgsize2);

	 if ((*dsthdl->io_put)(dsthdl, msgsize2) == NOTOK) {
	    report_error(NULL, "io_put");
	    return NOTOK;
	}

	if (interupted)
	    break;
	TIMING_DELAY(0);
    }
	
    StopMeasurements(mt);

    DiscRequest(ch, &error);
    if (failed(&error)) {
	report_error(&error, "DiscRequest");
	return NOTOK;
    }
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;

    return OK;
} /* rpci */
