/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring copy "throughput" (word copy)
 *
 * Parameters: the size must be a multiple of 32 (8 longwords)!!
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>

#define NO_DELAY
#define NO_INT
#define NO_SRC
#define NO_DST


int copy2(be, addr, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct address_t 	*addr;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    INITIATOR_VARIABLES;
    TIMING_VARIABLES(0);
    channel_t 		ch;

    TIMING_INITIATE(0);

    mprintf("copy2(src 0x%x, dst 0x%x, mt 0x%x)\n",
		srchdl, dsthdl, mt);

    INITIATOR_BEFORE_START;
    
    StartMeasurements(mt);

    INITIATOR_AFTER_START;


    for (i = 0; i < iterations; i++) {
#ifndef NO_INT
	if (interupted)
	    break;
#endif NO_INT
	INITIATOR_SENDSIZE(msgsize, i);
#ifndef NO_SRC	
	if ((*srchdl->io_get)(srchdl, msgsize) == NOTOK) {
	    report_error(NULL, "io_get");
	    return NOTOK;
	}
#endif NO_SRC	
	MetricsAddDatasent(mt, msgsize);

	{
	  register int *from ,*end, *to;

	  from = (int *)srchdl->io_bufptr;
	  end = from + (msgsize>>2);
	  to = (int *)dsthdl->io_bufptr;
	  while (from < end) {
	    *to++ = *from++;
	    *to++ = *from++;
	    *to++ = *from++;
	    *to++ = *from++;
	    *to++ = *from++;
	    *to++ = *from++;
	    *to++ = *from++;
	    *to++ = *from++;
	  }
	}

#ifndef NO_INT	
	if (interupted)
	    break;
#endif NO_INT
#ifndef NO_DST	
	if ((*dsthdl->io_put)(dsthdl, msgsize) == NOTOK) {
	    report_error(NULL, "io_put");
	    return NOTOK;
	}
#endif NO_DST
	MetricsAddDatarcvd(mt, msgsize);

#ifndef NO_INT
	if (interupted)
	    break;
#endif NO_INT
#ifndef NO_DELAY	
	TIMING_DELAY(0);
#endif NO_DELAY	
    }

    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;

    return OK;
} /* copy2 */




