/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Error definitions
 */

#include <sys/errno.h>


#define INTERNAL 	"Internal error"
#define SPECIFICATION	"Bad specification"
#define UNSUPP		"Unsupported"
#define COMMUNICATION	"Communication problem"
#define	PROTOCOL	"Benchmark Control Protocol"
#define CONTROL		"Execution control module"
#define RESOURCE	"Resource shortage"
#define PARAMETER	"Bad parameter"
#define IPC		"Interprocess communication"

/*
 * Error format strings
 */
#define EF_SYSCALL	"%s: %s in %s: Error: %s\n"
#define EF_IN3		"%s: %s in %s\n"
#define EF_IN4		"%s - %s: %s in %s\n"
#define EF_IN4X		"%s: %s in %s - %s\n"
#define EF_3		"%s: %s %s\n"

/* Possible to avoid debugging code with -DDebug=0 et.c. */

#ifndef Trace
extern int Trace;
#endif
#ifndef Debug
extern int Debug;
#endif

extern int ProtoDebug, StateTrace, IPCTrace, ProcDebug;
extern int NoEcho;


#define dprintf \
	if (Debug) printmyname(), printf
#define tprintf \
        if (Trace) printmyname(), printf
#define pprintf \
        if (ProtoDebug) printmyname(), printf
#define stprintf \
        if (StateTrace) printmyname(), printf
#define iprintf \
        if (IPCTrace) printmyname(), printf
#define mprintf \
        if (ProcDebug) printmyname(), printf

    


extern int errno, sys_nerr;
extern char *sys_errlist[];

#define getsyserr() 	\
    ((errno < sys_nerr) ? sys_errlist[errno] : "Unknown error number")


