/*
	Written by Ross Cartlidge (rossc@extro.ucc.su.oz)
	University Computer Service
	March 1989

	tcpcon - Program to connect a tty to a tcp socket
	Developed on a MIPS M/2000 running SysVr3
	Ported to BSD/SUN-OS
*/
#include	<fcntl.h>
#include	<sys/ioctl.h>
#include	<sys/signal.h>
#include	<sys/types.h>
#include	<syslog.h>
#include	<errno.h>
#include	<stdio.h>
#include	<string.h>
#if defined(SYSTYPE_SYSV)
#include	<malloc.h>
#else
extern char	*malloc();
extern char	*calloc();
#endif

#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <setjmp.h>

#define max(a,b) 	((a)<(b) ? (b) : (a))
#define min(a,b) 	((a)>(b) ? (b) : (a))

#if defined(SYSTYPE_BSD43)
#define sigset		signal
#define sighold(s)	sigblock(sigmask(s))
#define sigrelse(s)	sigsetmask(sigsetmask(-1) & ~sigmask(s))
extern int		errno;
#endif

#if !defined(FD_SET)
#define	fd_set	int
#define	FD_SET(n,p)	(*(p) |= 1 << (n))
#define	FD_CLR(n,p)	(*(p) &= ~(1 << (n)))
#define	FD_ISSET(n,p)	(*(p) & 1 << (n))
#define	FD_ZERO(p)	(*(p) = 0)
#endif

jmp_buf	env;
int	pid;
int	term;
char	*daemon	= (char *)0;
int	bufsize		= 256;
int	linger_time	= 5;
int	soc		= -1;
long	ofrom_socket;
long	oto_socket;
long	orfrom_socket;
long	orto_socket;
long	from_socket;
long	to_socket;
long	rfrom_socket;
long	rto_socket;
int	inactivetime	= 0;
int	sesstime	= 0;

main(argc, argv)
int	argc;
char	*argv[];
{
	struct hostent		*host;
	struct servent		*serv;
	struct sockaddr_in	sin;
	struct sockaddr_in	from;
	int			fromlen;
	int			recv;
	int			ls;
	int			i;
	int			r;
	char			perror_fmt[128];
	char			usage[128];
	int			p;
	fd_set			rfds;
	fd_set			efds;
	fd_set			wfds;
	char			*dev		= (char *)0;
	char			*kdev		= (char *)0;
	char			*statfile	= (char *)0;
	FILE			*sf		= (FILE *)0;
	FILE			*daemonf	= (FILE *)0;
	char			*basename;
	int			update		= 30;
	long			slw;
	long			olw;
	long			lw;
	int			et;
	int			errflg		= 0;
	void			finish();
	void			terminate();
	void			timeout();
	int			c;
	int			status;
	char			*buf;
	int			con_type;
	char			*sttyargs	= (char *)0;
	char			sttycmd[512];
	extern char		*optarg;
	extern int		optind;

	sprintf(perror_fmt, "PERROR_FMT=%s: %%t %%s%%m - (%%e)", argv[0]);
	sprintf
	(
		usage,
		"USAGE: %s [-d file] [-a] [-l pty] [-k tty] [-i timeout] [-s timeout] <IP Address> <TCP Port>\n", argv[0]
	);
#if defined(SYSTYPE_SYSV)
	putenv(perror_fmt);
#endif
	while ((c = getopt(argc, argv, "d:a:l:k:s:b:u:i:t:S:")) != -1)
		switch (c)
		{
		case 'a':
			linger_time = atoi(optarg);
			break;
		case 'k':
			kdev = optarg;
			break;
		case 'l':
			dev = optarg;
			break;
		case 's':
			statfile = optarg;
			break;
		case 'b':
			bufsize = atoi(optarg);
			break;
		case 'u':
			update = atoi(optarg);
			break;
		case 'd':
			daemon = optarg;
			break;
		case 'i':
			inactivetime = atoi(optarg) * 60;
			break;
		case 't':
			sesstime = atoi(optarg) * 60;
			break;
		case 'S':
			sttyargs = optarg;
			break;
		case '?':
			errflg++;
		}
	if (basename = strrchr(argv[0], '/'))
		basename++;
	else
		basename = argv[0];
	if (*basename == 't')
		con_type =  SOCK_STREAM;
	else
		con_type =  SOCK_DGRAM;
	if (errflg || optind >= argc)
	{
		fputs(usage, stderr);
		exit(2);
	}
	optind--;	/* make port code same for connect */
	sin.sin_addr.s_addr = INADDR_ANY;
	if
	(
		serv = getservbyname
		(
			argv[optind + 1],
			con_type == SOCK_DGRAM ? "udp" : "tcp"
		)
	)
		sin.sin_port = serv->s_port;
	else
		if
		(
			(
				sin.sin_port
				=
				htons
				(
					(short)strtol(argv[optind + 1],
					(char **)0, 0)
				)
			)
			<=
			0
		)
		{
			fprintf
			(
				stderr,
				"%s: %s: unknown service\n",
				argv[0],
				argv[optind + 1]
			);
			exit(2);
		}
	if ((ls = connectsocket(&sin, con_type)) < 0)
		finish(1);
	if ((buf = malloc(bufsize)) == (char *)0)
	{
		perror("malloc buf");
		finish(1);
	}
	if (daemon)
		if (pid = fork())
		{
			if ((daemonf = fopen(daemon, "w")) != NULL)
			{
				fprintf(daemonf, "%d\n", pid);
				exit(0);
			}
			else
			{
				perror(daemon);
				exit(1);
			}
		}
		else
#if defined(SYSTYPE_BSD43)
			setpgrp(getpid(), 0);
#endif
#if defined(SYSTYPE_SYSV)
			setpgrp();
#endif
	sigset(SIGTERM, terminate);
	sigset(SIGHUP, terminate);
	do
	{
		sighold(SIGTERM);
		sighold(SIGHUP);
		if (term == 1)
			finish(1);

		if (dev)
		{
			close(0);
			close(1);
		}
		if (pid = fork())
		{
			sigrelse(SIGTERM);
			sigrelse(SIGHUP);
			if (kdev != (char *)0 && open(kdev, O_RDWR) == -1)
				kill(pid, SIGTERM);
			if (dev)
			{
#if defined(SYSTYPE_BSD43)
				setpgrp(getpid(), 0);
#endif
#if defined(SYSTYPE_SYSV)
				setpgrp();
#endif
			}
			while (wait(&status) != -1 || errno == EINTR)
				;
			continue;
		}
		sigset(SIGTERM, SIG_DFL);
		sigset(SIGHUP, SIG_DFL);
		sigset(SIGALRM, timeout);
		sigrelse(SIGTERM);
		sigrelse(SIGHUP);
		sigrelse(SIGALRM);

		if (dev)
		{
#if defined(SYSTYPE_BSD43)
			setpgrp(getpid(), 0);
#endif
#if defined(SYSTYPE_SYSV)
			setpgrp();
#endif
		}
		if (con_type == SOCK_DGRAM)
		{
			fromlen = sizeof from;
			if ((recv = recvfrom(ls, buf, bufsize, 0, &from, &fromlen)) == -1)
			{
				perror("recvfrom");
				finish(1);
			}
			soc = dup(ls);
			connect(soc, &from, fromlen);
		}
		else
		{
			recv = 0;
			if ((soc = accept(ls, (struct sockaddr *)0, (int *)0)) < 0)
			{
				perror("accept");
				finish(1);
			}
		}
		if (dev)
		{
			dup(soc);
			soc = dup(soc);
			close(0);
			close(1);
			if (open(dev, O_RDWR) == -1)
			{
				perror(dev);
				finish(1);
			}
			dup(0);
			if (sttyargs)
			{	
				sprintf(sttycmd, "/bin/stty %s", sttyargs);
				system(sttycmd);
			}
		}
		
		time(&olw);
		time(&slw);
		if (statfile && (sf = fopen(statfile, "w")) == NULL)
		{
			perror(statfile);
			finish(1);
		}
		time(&lw);
		if (sf)
		{
			et = max(1, lw -slw);
			fprintf(sf,"%10s%8s%10s%8s%10s%8s%10s%8s%8s\n",
				"chars <-",
				"c/s <-",
				"reads <-",
				"r/s <-",
				"chars ->",
				"c/s ->",
				"reads ->",
				"r/s ->",
				"time"
			);
			fprintf(sf,"%10d%8d%10d%8d%10d%8d%10d%8d%8d\n",
				from_socket,
				(from_socket - ofrom_socket)/et,
				rfrom_socket,
				(rfrom_socket - orfrom_socket)/et,
				to_socket,
				(to_socket - oto_socket)/et,
				rto_socket,
				(rto_socket - orto_socket)/et,
				et
			);
			fflush(sf);
			rewind(sf);
			olw = lw;
			ofrom_socket = from_socket;
			oto_socket = to_socket;
			orfrom_socket = rfrom_socket;
			orto_socket = rto_socket;
		}
		if (recv && Write(1, buf, recv, &from_socket, &rfrom_socket) != recv)
		{
			perror("write");
			finish(0);
		}
		for (;;)
		{
			FD_ZERO(&rfds);
			FD_ZERO(&efds);
			FD_SET(0, &rfds);
			FD_SET(soc, &rfds);
			FD_SET(0, &efds);
			FD_SET(soc, &efds);
			alarm((int) (inactivetime <= 0
				? max(sesstime - rtime(),0)
				: min(max(sesstime - rtime(),0),inactivetime)));
			select(soc + 1, &rfds, (fd_set *)0, &efds, (struct timeval *)0);
			alarm(0);
			if (sf && time(&lw) > olw + update)
			{
				et = max(1, lw -olw);
				fprintf(sf,"%10s%8s%10s%8s%10s%8s%10s%8s%8s\n",
					"chars <-",
					"c/s <-",
					"reads <-",
					"r/s <-",
					"chars ->",
					"c/s ->",
					"reads ->",
					"r/s ->",
					"time"
				);
				fprintf(sf,"%10d%8d%10d%8d%10d%8d%10d%8d%8d\n",
					from_socket,
					(from_socket - ofrom_socket)/et,
					rfrom_socket,
					(rfrom_socket - orfrom_socket)/et,
					to_socket,
					(to_socket - oto_socket)/et,
					rto_socket,
					(rto_socket - orto_socket)/et,
					lw - slw
				);
				fflush(sf);
				rewind(sf);
				olw = lw;
				ofrom_socket = from_socket;
				oto_socket = to_socket;
				orfrom_socket = rfrom_socket;
				orto_socket = rto_socket;
			}

			if (term)
				break;

			if (FD_ISSET(soc, &rfds) || FD_ISSET(soc, &efds))
			{
				if ((r = read(soc, buf, bufsize)) <= 0)
				{
					finish(0);
				}
				if (Write(1, buf, r, &from_socket, &rfrom_socket) != r)
				{
/*
					perror("write");
*/
					finish(0);
				}
			}
			if ((FD_ISSET(0, &rfds) || FD_ISSET(0, &efds)))
			{
				if ((r = read(0, buf, bufsize)) <= 0)
				{
					finish(0);
				}
				if (Write(soc, buf, r, &to_socket, &rto_socket) != r)
				{
/*
					perror("write");
*/
					finish(0);
				}
			}
		}
	}
	while(daemon && !term);

	finish(0);
}

connectsocket(sinp, t)
struct sockaddr_in	*sinp;
int			t;
{
	int		s;
	int		l;
	int		sockopt;
	struct linger	lg;

	if ((s = socket(AF_INET, t, 0)) <  0)
	{
		perror("socket");
		return -1;
	}
	l = sizeof *sinp;
	if (bind(s, sinp, l) < 0)
	{
		perror("bind");
		finish(1);
	}
	if (t == SOCK_STREAM)
	{
		listen(s, 5);
	}
	if
	(
		t == SOCK_STREAM
		&&
		setsockopt
		(
			s,
			SOL_SOCKET,
			SO_RCVBUF,
			(sockopt = bufsize, (char *)&sockopt),
			sizeof sockopt
		)
		<
		0
	)
	{
		perror("setsockopt(SO_RCVBUF)");
		return -1;
	}
	if
	(
		t == SOCK_STREAM
		&&
		setsockopt
		(
			s,
			SOL_SOCKET,
			SO_SNDBUF,
			(sockopt = bufsize, (char *)&sockopt),
			sizeof sockopt
		)
		<
		0
	)
	{
		perror("setsockopt(SO_SNDBUF)");
		return -1;
	}
	if
	(
		t == SOCK_STREAM
		&&
		setsockopt
		(
			s,
			SOL_SOCKET,
			SO_LINGER,
			(lg.l_onoff = 1, lg.l_linger = linger_time,  &lg),
			sizeof lg
		)
		<
		0
	)
	{
		perror("setsockopt(SO_LINGER)");
		return -1;
	}
	if
	(
		t == SOCK_STREAM
		&&
		setsockopt
		(
			s,
			SOL_SOCKET,
			SO_KEEPALIVE,
			(sockopt = 1, (char *)&sockopt),
			sizeof sockopt
		)
		<
		0
	)
	{
		perror("setsockopt(SO_KEEPALIVE)");
		return -1;
	}
	return s;
}

long
rtime()
{
	static long	n	= 0L;

	if (n == 0L) time(&n);

	return(time(NULL) - n);
}


char *
tmtos(t)
long 	t;
{
		int	hrs;
		int	mins;
		int	sec;
	static	char	s[64];

	hrs	= t / 3600;
	mins	= (t % 3600) / 60;
	sec	= t % 60;

	strcpy(s, "");
	if (hrs > 0) sprintf(s + strlen(s), "%d hr ", hrs);
	if (mins > 0) sprintf(s + strlen(s), "%d min ", mins);
	if (sec > 0) sprintf(s + strlen(s), "%d sec", sec);

	if ((strlen(s) > 0) && (s[strlen(s) - 1] == ' '))
		s[strlen(s) - 1]	= '\0';

	return(s);
}

void
timeout()
{
	if ((sesstime > 0) && (rtime() >= sesstime))
		printf("\r\nSession Timeout(%s)\r\n", tmtos(sesstime));
	else
		printf("\r\nInactivity Timeout(%s)\r\n",tmtos(inactivetime));
	fflush(stdout);
	sleep(1);
	terminate(SIGALRM);
}


void
terminate(s)
int	s;
{
	if (pid != 0)	
		kill(pid, s);

	switch(s)
	{
	case SIGTERM:
	case SIGALRM:
		term = 1;
	}
}

void
finish(i)
int	i;
{
	if (soc != -1)
		shutdown(soc, 2);

	if (pid != 0)
		unlink(daemon);

	close(0);
	close(1);
	close(2);
	exit(i);
}


Write(f, buf, len, cnt, wcnt)
int	f;
char	*buf;
int	len;
long	*cnt;
long	*wcnt;
{
	int	i;

	i = write(f, buf, len);
	if (i > 0)
	{
		*cnt += i;
		(*wcnt)++;
	}
	return i;
}
