

#include "common.h"
#include "db.h"
#include "funcs.h"
/* The union that describes the various possible data types */


/* database structure */

typedef struct db_record {
	char *name;
	struct db_record *next;
	byte hflags;
	int intval;			/* the cell's value */
	datehold access_date;		/* last time of access */
	} userdb;

typedef struct ng_record {
	char *key;		/* name of newsgroup */
	struct ng_record *next;
	char flags;
	char gflag;		/* flags for the group */
	int16 ngnumber;		/* newsgroup number */
	int32 lowest;		/* lowest art, from active file */
	int32 highest;		/* highest from active file */
	int32 las;		/* last article seen */
	short chain;		/* chain in order of .newsrc */
	short distribution;	/* distribution number for this newsgroup */
	char *seenlist;		/* list of articles seen from .newsrc */
	int16 slistlen;		/* length of seen list */
	} ngrec;

#define iswhite(x) (strchr(" \t", x)!=0)
/* newsgroup name macro */
extern ngrec **ngarray;
#define ngn(x)	ngarray[x]->key		/* news group name */

/* flags for article routine */
#define A_FILE 0
#define A_PIPE 1

/* flags on groups */

#define GF_DIRTY 1
#define GF_ACTIVE 2
#define GF_LASGROUP 4		/* found in LAS file */
#define GF_UNSUB 8		/* unsubscribed group */
#define GF_RCGROUP 16		/* found in .newsrc file */

/* modes of operation */
#define MODE_NONE 0		/* no mode specified */
#define MODE_NEWSRC 1		/* read and write a .newsrc */
#define MODE_FLIST 2		/* read and write file list on stdin/stdout */
#define MODE_PIPE 3		/* converse with a newsreader */

/* reading modes */
#define FILE_FULL 1
#define FILE_REQUEST 2
#define PIPE_READ 3

#define ERRCODE -1		/* error code in pipe routines */

#define NULL_NEWSGROUP 0
#define NG_EXTRAS 20		/* extra negative newsgroup numbers */
#define SLIST_EXTRAS 15		/* extra bytes to allocate for seen lists */
#define STRIP_CODE	'S'	/* white space strip delimiter code */

